package com.agilex.healthcare.mobilehealthplatform.restservice;

import java.net.URI;
import java.util.Map.Entry;
import java.util.Locale;
import java.util.Set;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.agilex.healthcare.mobilehealthplatform.healthcheck.SystemProperties;
import com.agilex.healthcare.utility.NullChecker;

@Path("/metrics")
@Component
@Scope("request")
public class SystemMetricsResource {

	@GET
	@Produces({ "application/xml", "application/json" })
	public Document getMetrics(@QueryParam("k") String searchKey, @Context UriInfo u, @Context HttpHeaders headers) {
		Document doc;
		try {
			doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
		} catch (ParserConfigurationException e) {
			throw new RuntimeException(e);
		}

		Element metricsElement = doc.createElement("metrics");
		doc.appendChild(metricsElement);

		Set<Entry<String, String>> metrics = SystemProperties.getData();
		for (Entry<String, String> entry : metrics) {
			boolean match;

			if (NullChecker.isNullish(searchKey)) {
				match = true;
			} else {
				match = entry.getKey().toLowerCase(Locale.ENGLISH).startsWith(searchKey.toLowerCase(Locale.ENGLISH));
			}

			if (match) {
				Element metricElement = doc.createElement("metric");
				metricElement.setAttribute("key", entry.getKey());
				metricElement.setAttribute("value", entry.getValue());
				URI uri = UriBuilder.fromUri(u.getAbsolutePath()).path(entry.getKey()).build();
				Element linkElement = doc.createElement("link");
				linkElement.setAttribute("rel", "self");
				linkElement.setAttribute("href", uri.toString());
				linkElement.setAttribute("type", "text/plain");
				metricElement.appendChild(linkElement);
				metricsElement.appendChild(metricElement);
			}
		}
		return doc;
	}

	@GET
	@Produces({ "text/plain" })
	@Path("{metric-key}")
	public String getMetric(@PathParam("metric-key") String key, @Context UriInfo u, @Context HttpHeaders headers) {
		return SystemProperties.getValue(key);
	}
}
