package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.*;
import javax.ws.rs.core.*;

import com.agilex.system.health.*;
import org.springframework.stereotype.Service;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;

@Path("/admin/systemhealth/")
@Service
public class SystemHealthResource {

    @GET
    @Path("connectedSystems")
    @Produces({ "application/xml", "application/json" })
    public Services connectedSystems(@Context UriInfo u) {
		MhpObjectFactory factory = new MhpObjectFactory();
        HealthCheckRunner runner = factory.getHealthCheckComponent();

        return runner.connectedServices();
    }

    @GET
    @Path("connectionTest")
    @Produces({ "application/xml", "application/json" })
    public ConnectionStatus connectionTest(@QueryParam("system") String system, @Context UriInfo u) {
        MhpObjectFactory factory = new MhpObjectFactory();
        HealthCheckRunner runner = factory.getHealthCheckComponent();

        return runner.runConnectionTest(system);
    }

    @GET
    @Path("smokeTest")
    @Produces({ "application/xml", "application/json" })
    public SmokeTestStatus smokeTest(@QueryParam("system") String system) {
        MhpObjectFactory factory = new MhpObjectFactory();
        HealthCheckRunner runner = factory.getHealthCheckComponent();

        return runner.runSmokeTest(system);
    }
}
