package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.staffdirectory.StaffDirectoryDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.StaffDirectorySearchResults;


@Path("/staff-directory") // add to security definitions
@Component
@Scope("request")
public class StaffDirectoryResource {
	
	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("site/{site-id}/staff")
	public StaffDirectorySearchResults queryStaffBySite(@PathParam("site-id") String facilitySiteCode, @QueryParam("term") String term, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
		StaffDirectoryDataService dataService = new StaffDirectoryDataService();
		
		return dataService.queryStaffBySite(facilitySiteCode, term);
	}	
}
