package com.agilex.healthcare.mobilehealthplatform.restservice;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageUser;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageUsers;
import com.agilex.healthcare.mobilehealthplatform.domain.code.AssigningAuthorityCode;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.PatientDataLinkBuilder;

public class SecureMessageUserLinkBuilder extends PatientDataLinkBuilder<SecureMessageUsers, SecureMessageUser> {

	public SecureMessageUserLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(SecureMessageUser dataItem) {
		return UriBuilder.fromUri(getBaseUri()).path("securemessage-service").path(AssigningAuthorityCode.SECURE_MESSAGE).path(dataItem.getPatientId()).path("secure-message-user").build();
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return null;
	}

	@Override
	protected void fillCustomRelatedLinks(SecureMessageUser dataItem) {
		URI secureMessageBaseUri = UriBuilder.fromUri(getBaseUri()).path("securemessage-service").path(dataItem.getPatientIdentifier().getAssigningAuthority()).path(dataItem.getPatientIdentifier().getUniqueId()).build();
		
		dataItem.getLink().addRelatedLink("folders", UriBuilder.fromUri(secureMessageBaseUri).path("folders").build());
		dataItem.getLink().addRelatedLink("contacts", UriBuilder.fromUri(secureMessageBaseUri).path("contacts").build());
		dataItem.getLink().addRelatedLink("send", UriBuilder.fromUri(secureMessageBaseUri).path("messages").build());
		dataItem.getLink().addRelatedLink("save-draft", UriBuilder.fromUri(secureMessageBaseUri).path("drafts").path("messages").build());
	}

	@Override
	protected void fillCustomRelatedLinks(SecureMessageUsers dataList) {}

}
