package com.agilex.healthcare.mobilehealthplatform.restservice;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.datalayer.securemessage.SecureMessageFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageFolder;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageFolders;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.PatientDataLinkBuilder;

public class SecureMessageFolderLinkBuilder extends PatientDataLinkBuilder<SecureMessageFolders, SecureMessageFolder> {

	public SecureMessageFolderLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(SecureMessageFolder dataItem) {
		return null;
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return null;
	}

	@Override
	protected void fillCustomRelatedLinks(SecureMessageFolder dataItem) {
	}

	@Override
	protected void fillCustomRelatedLinks(SecureMessageFolders folders) {
		for(SecureMessageFolder folder : folders) {
			URI folderBaseUri = buildFolderBaseUri(folder);
			folder.getLink().addRelatedLink("messages", UriBuilder.fromUri(folderBaseUri).path("messages").queryParam(SecureMessageFilter.PAGE_NUMBER, "1").queryParam(SecureMessageFilter.PAGE_SIZE, 25).build());
		}
	}
	
	URI buildFolderBaseUri(SecureMessageFolder folder) {
		return UriBuilder.fromUri(getBaseUri()).path("securemessage-service").path(folder.getPatientIdentifier().getAssigningAuthority()).path(folder.getPatientId()).path("folders").path("id").path(folder.getUniqueId()).build();
	}
	

}
