package com.agilex.healthcare.mobilehealthplatform.restservice;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.datalayer.securemessage.SecureMessageFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessages;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.PatientDataLinkBuilder;
import com.agilex.healthcare.utility.NullChecker;

public class SecureMessageDraftLinkBuilder extends PatientDataLinkBuilder<SecureMessages, SecureMessage> {

	public SecureMessageDraftLinkBuilder(URI baseUri) {
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(SecureMessage dataItem) {
		String userId = dataItem.getPatientId();
		return UriBuilder.fromUri(getBaseUri()).path("securemessage-service").path(userId).path("messages").path("id").path(dataItem.getUniqueId()).build();
	}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return null;
	}

	@Override
	protected void fillCustomRelatedLinks(SecureMessage dataItem) {
		URI secureMessageBaseUri = UriBuilder.fromUri(getBaseUri()).path("securemessage-service").path(dataItem.getPatientIdentifier().getAssigningAuthority()).path(dataItem.getPatientId()).build();

		dataItem.getLink().addRelatedLink("save-draft", UriBuilder.fromUri(secureMessageBaseUri).path("drafts").path("messages").build());
		dataItem.getLink().addRelatedLink("read", UriBuilder.fromUri(secureMessageBaseUri).path("messages").path("id").path(dataItem.getUniqueId()).path("addressee-id").path(dataItem.getAddresseeId()).path("addressee-oplock").path(dataItem.getAddresseeOplock()).build());
		dataItem.getLink().addRelatedLink("send", UriBuilder.fromUri(secureMessageBaseUri).path("drafts").path("messages").path("id").path(dataItem.getUniqueId()).build());
		dataItem.getLink().addRelatedLink("delete", UriBuilder.fromUri(secureMessageBaseUri).path("drafts").path("messages").path("id").path(dataItem.getUniqueId()).build());
		dataItem.getLink().addRelatedLink("print", UriBuilder.fromUri(secureMessageBaseUri).path("messages").path("id").path(dataItem.getUniqueId()).build());
	}

	@Override
	protected void fillCustomRelatedLinks(SecureMessages secureMessages) {
		for (SecureMessage secureMessage : secureMessages) {
			fillCustomRelatedLinks(secureMessage);
		}
		addAdditionalLinks(secureMessages);
	}

	private URI buildSecureMessagesBaseUri(SecureMessages secureMessages) {
		SecureMessage secureMessage = secureMessages.get(0);
		return UriBuilder.fromUri(getBaseUri()).path("securemessage-service").path(secureMessage.getPatientIdentifier().getAssigningAuthority()).path(secureMessage.getPatientId()).path("folders").path("id").path(secureMessage.getFolderId()).path("messages").build();
	}

	private void addAdditionalLinks(SecureMessages secureMessages) {
		if (NullChecker.isNullish(secureMessages))
			return;

		URI messagesBaseUri = buildSecureMessagesBaseUri(secureMessages);
		if (secureMessages.hasNext())
			addNextLink(secureMessages, messagesBaseUri);

		if (secureMessages.hasPrevious())
			addPreviousLink(secureMessages, messagesBaseUri);
	}

	public void addNextLink(SecureMessages secureMessages, URI messagesBaseUri) {
		secureMessages.getLink().addRelatedLink("next", UriBuilder.fromUri(messagesBaseUri).queryParam(SecureMessageFilter.PAGE_NUMBER, secureMessages.nextPageNumber()).queryParam(SecureMessageFilter.PAGE_SIZE, secureMessages.getPageSize()).build());
	}

	public void addPreviousLink(SecureMessages secureMessages, URI messagesBaseUri) {
		secureMessages.getLink().addRelatedLink("previous", UriBuilder.fromUri(messagesBaseUri).queryParam(SecureMessageFilter.PAGE_NUMBER, secureMessages.previousPageNumber()).queryParam(SecureMessageFilter.PAGE_SIZE, secureMessages.getPageSize()).build());
	}
}
