package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.calendar.CalendarDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.calendar.CalendarKeyDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;

@Path("/public/calendar/")
public class PublicCalendarResource {

	@GET
	@Path("key/{calendar-key}/events")
	@Produces({ "application/xml", "application/json" })
	public Appointments getCalendarEventsByKey(@PathParam("calendar-key") String calendarKey, @Context UriInfo u, @Context HttpHeaders headers) {
		String patientId = lookupPatientIdByKey(calendarKey);
		return getCalendarEventsByPatient("EDIPI", patientId, u, headers);
	}

	@GET
	@Path("key/{calendar-key}/feed")
	@Produces({ "text/calendar" })
	public String getCalendarFeedByKey(@PathParam("calendar-key") String calendarKey, @Context UriInfo u, @Context HttpHeaders headers) {
		String patientId = lookupPatientIdByKey(calendarKey);
		return getCalendarFeedByPatient("EDIPI", patientId, u, headers);
	}

	// todo: this will be moved out of the "public" path, but here to help with
	// testing
	@GET
	@Path("patient/{assigning-authority}/{patient-id}/events")
	@Produces({ "application/xml", "application/json" })
	public Appointments getCalendarEventsByPatient(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @Context UriInfo u, @Context HttpHeaders headers) {
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);

		AppointmentDataService dataservice = new AppointmentDataService();
		DateFilter dateFilter = DateFilterFactory.createCalendarApplicationDateFilter(u.getRequestUri());

		Appointments appointments = dataservice.getPatientAppointments(patientIdentifier, dateFilter);
		return appointments;
	}

	// todo: this will be moved out of the "public" path, but here to help with
	// testing
	@GET
	@Path("patient/{assigning-authority}/{patient-id}/feed")
	@Produces({ "text/calendar" })
	public String getCalendarFeedByPatient(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @Context UriInfo u, @Context HttpHeaders headers) {
		PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);

		CalendarDataService dataservice = new CalendarDataService();
		return dataservice.getAggregatedPatientCalendar(patientIdentifier, DateFilterFactory.createCalendarApplicationDateFilter(u.getRequestUri()));
	}

	private String lookupPatientIdByKey(String key) {
		CalendarKeyDataService dataservice = new CalendarKeyDataService();
		return dataservice.fetchPatientByKey(key);
	}
}
