package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults.AssessmentResultsDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResult;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.code.AssessmentCode;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

@Component
@Scope("request")
@Path("public/assessments/results")
public class PublicAssessmentResultsResource {
	private PatientIdentifier anonymousPatientIdentifier = AssessmentCode.ANONYMOUS_RESULT_PATIENT_ID;
	private ScopeFilter scope = ScopeFilter.getInstanceForLongitudinalScope();

	/**
	 * A resource for posting an anonymous {@link AssessmentResult}.
	 */
	@POST
	@Consumes({ "application/xml", "application/json" })
	public AssessmentResult saveAssessmentResult(AssessmentResult assessmentResult, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
		assessmentResult.setPatientIdentifier(anonymousPatientIdentifier);

		AssessmentResultsDataService dataservice = new AssessmentResultsDataService();
		AssessmentResult savedAssessmentResult = dataservice.saveResult(assessmentResult, scope);
		return savedAssessmentResult;
	}
}