package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;

@Path("/provider")
@Component
@Scope("request")
public class ProviderAppointmentsResource {

	@GET
	@Produces({ "text/calendar" })
	@Path("{id}/appointments")
	public String getProviderAppointmentsAsIcsById(@PathParam("id") String providerId, @Context UriInfo u, @Context HttpHeaders headers) {
		AppointmentDataService appointmentsDataService = new AppointmentDataService();

		DateFilter datefilter = DateFilterFactory.createCalendarApplicationDateFilter(u.getRequestUri());
		Appointments appointments = appointmentsDataService.getProviderAppointments(providerId, datefilter);
		String ics = appointmentsDataService.createIcsFromAppointments(appointments);

		return ics;
	}

	@GET
	@Produces({ "text/calendar" })
	@Path("appointments")
	public String getCurrentProviderAppointmentsAsIcs(@Context UriInfo u, @Context HttpHeaders headers) {
		return getProviderAppointmentsAsIcsById(getCurrentProviderId(), u, headers);
	}

	private String getCurrentProviderId() {
		MhpUser mhpUser = MhpUserFactory.createFromSecurityContext();
		String providerId = mhpUser.getId();
		return providerId;
	}

}
