package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.NotificationDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Property;
import com.agilex.healthcare.mobilehealthplatform.domain.PropertyDirectory;
import com.agilex.healthcare.mobilehealthplatform.utils.PropertyHelper;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.PropertyDirectoryLinkBuilder;

@Path("/public/property-directory")
@Component
@Scope("request")
public class PropertyDirectoryResource {
	
	@Resource
	private PropertyHelper propertyHelper;

	@GET
	@Produces({ "application/atom+xml", "application/json", "application/xml" })
	public PropertyDirectory fetchPropertyDirectory(@Context UriInfo u, @Context HttpHeaders headers) {
		PropertyDirectory propertyDirectory = PropertyDirectoryLinkBuilder.fetchProperties(u.getBaseUri(), u.getRequestUri());
		return propertyDirectory;
	}
	
	@GET
	@Path("/notification-option-enabled")
	public Property fetchNotificationOptStatus() {
		NotificationDataService service = new NotificationDataService(propertyHelper);
		Property notificationStatusProperty = service.fetchNotificationStatus();
		
		return notificationStatusProperty;
	}
}
