package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.radiology.RadiologyDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResult;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResults;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyTests;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.RadiologyResultsLinkBuilder;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.RadiologyTestsLinkBuilder;

@Path("/patient/{assigning-authority}/{patient-id}/radiology")
@Component
@Scope("request")
public class PatientRadiologyResource {

	/**
	 * Deprecated.
	 */
	@Deprecated
	@GET
	@Path("results")
	@Produces({ "application/xml", "application/json" })
	public RadiologyResults fetchRadiologyResults(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @Context UriInfo u, @Context HttpHeaders headers) {
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		RadiologyResults results = fetchRadiologyResults(patientIdentifier, ScopeFilter.getInstanceForLongitudinalScope(), u);
                return results;

        }

	/**
	 * Retrieves {@link RadiologyResults} by scope
	 * 
	 * This method accepts date query parameters.
	 * 
	 * @param assigningAuthority
	 * @param patientId
	 * @param scope
	 * @return
	 */
	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("results/scope/{scope}")
	public RadiologyResults fetchRadiologyResultsByScope(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("scope") String scope, @Context UriInfo u, @Context HttpHeaders headers) {
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
                RadiologyResults results = fetchRadiologyResults(patientIdentifier, ScopeFilter.getInstanceForScope(scope), u);
                return results;
	}

	/**
	 * Retrieves {@link RadiologyResults} by system
	 * 
	 * This method accepts date query parameters.
	 * 
	 * @param assigningAuthority
	 * @param patientId
	 * @param systemIdentifier
	 * @return
	 */
	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("results/system/{system-id}")
	public RadiologyResults fetchRadiologyResultsBySystem(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemIdentifier, @Context UriInfo u,
			@Context HttpHeaders headers) {
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		RadiologyResults results = fetchRadiologyResults(patientIdentifier, ScopeFilter.getInstanceForSystem(systemIdentifier), u);
		return results;

        }

	/**
	 * Retrieves a single {@link RadiologyResult}. This method represents the self link of a radiology result.
	 * 
	 * @param assigningAuthority
	 * @param patientId
	 * @param systemId
	 * @param id
	 * @param u
	 * @param headers
	 * @return
	 */
	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("results/system/{system-id}/id/{id}")
	public RadiologyResult fetchRadiologyResult(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemId, @PathParam("id") String id, @Context UriInfo u,
			@Context HttpHeaders headers) {
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		final DataIdentifier dataIdentifier = new DataIdentifier(systemId, id);

		RadiologyDataService dataService = new RadiologyDataService();
		RadiologyResult RadiologyResult = dataService.getRadiologyResult(patientIdentifier, dataIdentifier);

		RadiologyResultsLinkBuilder linkbuilder = new RadiologyResultsLinkBuilder(u.getBaseUri());
		linkbuilder.fillLinks(RadiologyResult, u.getRequestUri());

		if (RadiologyResult == null)
			throw ExceptionFactory.generateNoDataFoundException();

		return RadiologyResult;

        }

	private RadiologyResults fetchRadiologyResults(final PatientIdentifier patientIdentifier, ScopeFilter scopeFilter, UriInfo u) {
		RadiologyDataService dataService = new RadiologyDataService();

		DateFilter filter = DateFilterFactory.createFilterFromUri(u.getRequestUri());

		RadiologyResults radiologyResults = dataService.getRadiologyResults(patientIdentifier, filter, scopeFilter);

		RadiologyResultsLinkBuilder linkbuilder = new RadiologyResultsLinkBuilder(u.getBaseUri());
		linkbuilder.fillLinks(radiologyResults, u.getRequestUri());

		return radiologyResults;
	}
	
	/**
	 * Deprecated.
	 */
	@GET
	@Path("tests")
	@Produces({ "application/xml", "application/json" })
	public RadiologyTests getRadiologyTestsByScope(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @Context UriInfo uriInfo, 
			@Context HttpHeaders headers) {
		PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);

		RadiologyDataService service = new RadiologyDataService();
		DateFilter filter = DateFilterFactory.createFilterFromUri(uriInfo.getRequestUri());
		RadiologyTests tests = service.getRadiologyTests(patientIdentifier, filter, ScopeFilter.getInstanceForLongitudinalScope());

		RadiologyTestsLinkBuilder linkBuilder = new RadiologyTestsLinkBuilder(uriInfo.getBaseUri());
		linkBuilder.fillLinks(tests, uriInfo.getRequestUri());

		return tests;

        }

	/**
	 * Retrieves {@link RadiologyResults} grouped into {@link RadiologyTests} 
	 * 
	 * This method allows date filter query parameters.
	 * 
	 * @param assigningAuthority
	 * @param patientId
	 * @param scope
	 * @return {@link RadiologyTests}
	 */
	@GET
	@Path("tests/scope/{scope}")
	@Produces({ "application/xml", "application/json" })
	public RadiologyTests getRadiologyTestsByScope(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("scope") String scope, @Context UriInfo u, @Context HttpHeaders headers) {
		PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		return fetchRadiologyTests(patientIdentifier, ScopeFilter.getInstanceForScope(scope), u, headers);
        }
	
	/**
	 * Retrieves {@link RadiologyResults} grouped into {@link RadiologyTests} 
	 * 
	 * This method allows date filter query parameters.
	 * 
	 * @param assigningAuthority
	 * @param patientId
	 * @param scope
	 * @return {@link RadiologyTests}
	 */
	@GET
	@Path("tests/system/{system}")
	@Produces({ "application/xml", "application/json" })
	public RadiologyTests getRadiologyTestsBySystem(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system") String system, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
		PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		return fetchRadiologyTests(patientIdentifier, ScopeFilter.getInstanceForSystem(system), uriInfo, headers);
        }
	
	private RadiologyTests fetchRadiologyTests(PatientIdentifier patientIdentifier, ScopeFilter scopeFilter, UriInfo uriInfo, HttpHeaders headers) {
		
		RadiologyDataService service = new RadiologyDataService();
		DateFilter filter = DateFilterFactory.createFilterFromUri(uriInfo.getRequestUri());
		RadiologyTests tests = service.getRadiologyTests(patientIdentifier, filter, scopeFilter);
		
		RadiologyTestsLinkBuilder linkBuilder = new RadiologyTestsLinkBuilder(uriInfo.getBaseUri());
		linkBuilder.fillLinks(tests, uriInfo.getRequestUri());
		
		return tests;
	}


}
