
package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.preference.PatientPreferenceDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientPreference;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.PatientPreferencesLinkBuilder;

@Path("/patient/{assigning-authority}/{patient-id}/preference")
@Component
@Scope("request")
public class PatientPreferencesResource {
	
	@GET
	@Produces({ "application/xml", "application/json" })
	public PatientPreference fetchPatientPreferences(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @Context UriInfo u, @Context HttpHeaders headers) {
		
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);

		PatientPreferenceDataService dataService = new PatientPreferenceDataService();
		PatientPreference patPref = dataService.fetchPatientPreference(patientIdentifier);
		
		if (u != null) {
			PatientPreferencesLinkBuilder linkbuilder = new PatientPreferencesLinkBuilder(u.getBaseUri());
			linkbuilder.fillLinks(patPref, u.getRequestUri());
		}
		return patPref;
	}
	
	
	@PUT
	@Produces({ "application/xml", "application/json" })
	@Consumes({ "application/xml", "application/json" })
	public PatientPreference updatePatientPreferences(PatientPreference patPref, @PathParam("assigning-authority") String assigningAuthority,
			@PathParam("patient-id") String patientId, @Context UriInfo u, @Context HttpHeaders headers) {
		
		PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		patPref.setPatientIdentifier(patientIdentifier);

		PatientPreferenceDataService dataService = new PatientPreferenceDataService();
		PatientPreference updatePatPref = dataService.updatePatientPreference(patPref);
		if (u != null) {
			PatientPreferencesLinkBuilder linkBuilder = new PatientPreferencesLinkBuilder(u.getBaseUri());
			linkBuilder.fillLinks(updatePatPref, u.getRequestUri());
		}
		return updatePatPref;
	
	}
	
}
