package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.mood.MoodEventDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.MoodEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.MoodEvents;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.MoodLinkBuilder;

@Path("/patient/{assigning-authority}/{patient-id}/mood")
@Component
@Scope("request")
public class PatientMoodEventsResource extends AbstractJournalResource<MoodEvents, MoodEvent> {
	public PatientMoodEventsResource() {
		super(new MoodEventDataService(), MoodEvent.class);
	}

	@Override
	protected void fillLinks(MoodEvents datalist, UriInfo u) {
		MoodLinkBuilder linkbuilder = new MoodLinkBuilder(u.getBaseUri());
		linkbuilder.fillLinks(datalist, u.getRequestUri());
	}

	@Override
	protected void fillLinks(MoodEvent data, UriInfo u) {
		MoodLinkBuilder linkbuilder = new MoodLinkBuilder(u.getBaseUri());
		linkbuilder.fillLinks(data, u.getRequestUri());
	}
}
