package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.micro.MicrobiologyLabDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTestGroups;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTests;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.MicrobiologyLabUriHelper;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.MicrobiologyLabLinkBuilder;

@Path("/patient/{assigning-authority}/{patient-id}/lab-microbiology")
@Component
@Scope("request")
public class PatientMicrobiologyLabsResource {

	@GET
	@Path("results")
	@Produces({ "application/xml", "application/json" })
	@Deprecated
	public LabResults fetchResults(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @QueryParam("test-id") String testId, @QueryParam("specimenId") String specimenId, @Context UriInfo u,
			@Context HttpHeaders headers) {
	        final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
                LabResults results =  getMicrobiologyLabResults(patientIdentifier, testId, specimenId, ScopeFilter.getInstanceForLongitudinalScope(), u);
                return results;

        }

	@GET
	@Path("results/scope/{scope}")
	@Produces({ "application/xml", "application/json" })
	public LabResults fetchResultsByScope(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("scope") String scope, @Context UriInfo u, @Context HttpHeaders headers) {
	        final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
    	        LabResults results =  getMicrobiologyLabResults(patientIdentifier, ScopeFilter.getInstanceForScope(scope), u);
                return results;
	}

	@GET
	@Path("results/system/{system-id}")
	@Produces({ "application/xml", "application/json" })
	public LabResults fetchResultsBySystem(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemId, @Context UriInfo u, @Context HttpHeaders headers) {
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		LabResults results =  getMicrobiologyLabResults(patientIdentifier, ScopeFilter.getInstanceForSystem(systemId), u);
                return results;

        }
	
	@GET
	@Path("results/system/{system-id}/id/{result-id}")
	@Produces({ "application/xml", "application/json" })
	public LabResult getLabResultById(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemId, @PathParam("result-id") String resultId, @Context UriInfo u,
			@Context HttpHeaders headers) {
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		MicrobiologyLabDataService dataservice = new MicrobiologyLabDataService();
		LabResult result = dataservice.getMicrobiologyLabResult(patientIdentifier, resultId, ScopeFilter.getInstanceForSystem(systemId));
                return result;
            
        }

	@GET
	@Path("tests/scope/{scope}")
	@Produces({ "application/xml", "application/json" })
	public LabTests getLabTestsByScope(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("scope") String scope, @Context UriInfo u, @Context HttpHeaders headers) {
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		LabTests results =  getLabTests(patientIdentifier, ScopeFilter.getInstanceForScope(scope), u);
		return results;

        }

	@GET
	@Path("tests/system/{system-id}")
	@Produces({ "application/xml", "application/json" })
	public LabTests getLabTestsBySystem(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemId, @Context UriInfo u, @Context HttpHeaders headers) {
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		LabTests results = getLabTests(patientIdentifier, ScopeFilter.getInstanceForSystem(systemId), u);
                return results;
        
        }

	@GET
	@Path("groups/scope/{scope}")
	@Produces({ "application/xml", "application/json" })
	public LabTestGroups getLabTestsInGroupsByScope(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("scope") String scope, @Context UriInfo u, @Context HttpHeaders headers) {
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		LabTestGroups results =  getLabTestsInGroups(patientIdentifier, ScopeFilter.getInstanceForScope(scope), u);
		return results;

        }

	@GET
	@Path("groups/system/{system-id}")
	@Produces({ "application/xml", "application/json" })
	public LabTestGroups getLabTestsInGroupsBySystem(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemId, @Context UriInfo u, @Context HttpHeaders headers) {
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		LabTestGroups results= getLabTestsInGroups(patientIdentifier, ScopeFilter.getInstanceForSystem(systemId), u);
		return results;

        }

	@SuppressWarnings("deprecation")
	private LabResults getMicrobiologyLabResults(PatientIdentifier patientIdentifier, String testId, String specimenId, ScopeFilter scopeFilter, UriInfo u) {
		MicrobiologyLabDataService dataservice = new MicrobiologyLabDataService();

		LabResults results = dataservice.getLabResultsByTestAndSpecimen(patientIdentifier, testId, specimenId, scopeFilter);
		MicrobiologyLabUriHelper.updateLabResultsLinks(results, patientIdentifier, u);
		return results;
	}
	
	
	private LabResults getMicrobiologyLabResults(PatientIdentifier patientIdentifier, ScopeFilter scopeFilter, UriInfo uriInfo) {
		
		MicrobiologyLabDataService dataservice = new MicrobiologyLabDataService();
		DateFilter dateFilter = DateFilterFactory.createFilterFromUri(uriInfo);
		
		LabResults results = dataservice.getLabResults(patientIdentifier, dateFilter, scopeFilter);
		
		MicrobiologyLabLinkBuilder linkbuilder = new MicrobiologyLabLinkBuilder(uriInfo.getBaseUri());
		linkbuilder.fillLinks(results, uriInfo.getRequestUri());

		return results;
	}


	private LabTests getLabTests(PatientIdentifier patientIdentifier, ScopeFilter scopeFilter, UriInfo u) {
		MicrobiologyLabDataService dataservice = new MicrobiologyLabDataService();

		LabTests labTests = dataservice.getResultsGroupedByTest(patientIdentifier, scopeFilter);

		MicrobiologyLabUriHelper.updateLabTestsLinks(labTests, patientIdentifier, u);
		return labTests;
	}

	private LabTestGroups getLabTestsInGroups(PatientIdentifier patientIdentifier, ScopeFilter scopeFilter, UriInfo u) {
		MicrobiologyLabDataService dataservice = new MicrobiologyLabDataService();
		LabTestGroups labTestGroups = dataservice.getLabTestsInGroups(patientIdentifier, scopeFilter);

		MicrobiologyLabUriHelper.updateLabTestsLinks(labTestGroups, patientIdentifier, u);

		return labTestGroups;
	}

}
