package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationFilter;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.MedicationLinkBuilder;

@Path("/patient/{assigning-authority}/{patient-id}/medications")
@Component
@Scope("request")
public class PatientMedicationsResource {

	/**
	 * Returns all {@link Medications} matching the following filter parameters:
	 * <ul>
	 * <li>statuses: comma separated list of statuses for a medication</li>
	 * <li>resultCount: the number of results to return. This parameter must be
	 * supplied with the `page` parameter</li>
	 * <li>page: the page of results requested. This parameter must be supplied
	 * with the `resultCount` parameter</li>
	 * <li>sourceSystems: comma separated list of source systems for a
	 * medication</li>
	 * <li>medicationSources: comma separated list of medication sources for a
	 * medication</li>
	 * <li>startDate/endDate: a range of dates (in MM/dd/yyyy format) to match
	 * against the {@link Medication#getStartDate()} field.
	 * <li>date: a specific date to match for the
	 * {@link Medication#getStartDate()}.
	 * <li>numberOfPastMonths: an integer related to the number of past months
	 * to check for a {@link Medication#getStartDate()}.
	 * </ul>
	 * 
	 * @param assigningAuthority
	 * @param patientId
	 * @param uriInfo
	 * @return
	 */
	@GET
	@Produces({ "application/xml", "application/json" })
	@Deprecated
	public Medications fetchMedications(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @Context UriInfo u, @Context HttpHeaders headers) {
        
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		MedicationFilter filter = MedicationFilterFactory.createFilterFromUri(u.getRequestUri());
		Medications results = fetchMedications(patientIdentifier, filter, ScopeFilter.getInstanceForLongitudinalScope(), u);
                return results;

	}

	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("active")
	@Deprecated
	public Medications fetchActiveMedications(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @Context UriInfo u, @Context HttpHeaders headers) {
        
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		MedicationFilter filter = MedicationFilterFactory.createFilterFromUri(u.getRequestUri());
		filter.addActiveStatus(true);
		Medications results = fetchMedications(patientIdentifier, filter, ScopeFilter.getInstanceForLongitudinalScope(), u);
                return results;

        }

	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("scope/{scope}")
	public Medications fetchMedicationsByScope(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("scope") String scope, @Context UriInfo u, @Context HttpHeaders headers) {
        
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		MedicationFilter filter = MedicationFilterFactory.createFilterFromUri(u.getRequestUri());
                Medications results = fetchMedications(patientIdentifier, filter, ScopeFilter.getInstanceForScope(scope), u);
                return results;

        }

	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("scope/{scope}/active")
	public Medications fetchActiveMedicationsByScope(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("scope") String scope, @Context UriInfo u, @Context HttpHeaders headers) {
        
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		MedicationFilter filter = MedicationFilterFactory.createFilterFromUri(u.getRequestUri());
		filter.addActiveStatus(true);
                Medications results = fetchMedications(patientIdentifier, filter, ScopeFilter.getInstanceForScope(scope), u);
                return results;

        }

	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("system/{system-id}")
	public Medications fetchMedicationsBySystem(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemIdentifier, @Context UriInfo u, @Context HttpHeaders headers) {
        
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		MedicationFilter filter = MedicationFilterFactory.createFilterFromUri(u.getRequestUri());
                Medications results = fetchMedications(patientIdentifier, filter, ScopeFilter.getInstanceForSystem(systemIdentifier), u);
                return results;

	}

	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("system/{system-id}/active")
	public Medications fetchActiveMedicationsBySystem(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemIdentifier, @Context UriInfo u,
			@Context HttpHeaders headers) {
        
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		MedicationFilter filter = MedicationFilterFactory.createFilterFromUri(u.getRequestUri());
		filter.addActiveStatus(true);
                Medications results = fetchMedications(patientIdentifier, filter, ScopeFilter.getInstanceForSystem(systemIdentifier), u);
                return results;

        }

	/**
	 * Retuns all {@link Medications} where medication source is equivalent to
	 * outpatient. This method also takes the same parameters as
	 * {@link #fetchMedications(String, String, UriInfo)}
	 * 
	 * @param assigningAuthority
	 * @param patientId
	 * @param uriInfo
	 * @return
	 */
	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("outpatient")
	public Medications fetchOutpatientMedications(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @Context UriInfo u, @Context HttpHeaders headers) {
        
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		MedicationFilter filter = MedicationFilterFactory.createFilterFromUri(u.getRequestUri());
		filter.addMedicationSources(MedicationFilter.OUTPATIENT);
                Medications results = fetchMedications(patientIdentifier, filter, ScopeFilter.getInstanceForLongitudinalScope(), u);
                return results;

        }

	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("outpatient/active")
	public Medications fetchCurrentOutpatientMedications(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @Context UriInfo u, @Context HttpHeaders headers) {
        
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		MedicationFilter filter = MedicationFilterFactory.createFilterFromUri(u.getRequestUri());
		filter.addMedicationSources(MedicationFilter.OUTPATIENT);
		filter.addActiveStatus(true);
                Medications results = fetchMedications(patientIdentifier, filter, ScopeFilter.getInstanceForLongitudinalScope(), u);
                return results;

	}

	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("outpatient/scope/{scope}")
	public Medications fetchOutpatientMedicationsByScope(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("scope") String scope, @Context UriInfo u, @Context HttpHeaders headers) {
        
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		MedicationFilter filter = MedicationFilterFactory.createFilterFromUri(u.getRequestUri());
		filter.addMedicationSources(MedicationFilter.OUTPATIENT);
                Medications results = fetchMedications(patientIdentifier, filter, ScopeFilter.getInstanceForScope(scope), u);
                return results;

        }

	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("outpatient/scope/{scope}/active")
	public Medications fetchCurrentOutpatientMedicationsByScope(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("scope") String scope, @Context UriInfo u, @Context HttpHeaders headers) {
        
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		MedicationFilter filter = MedicationFilterFactory.createFilterFromUri(u.getRequestUri());
		filter.addMedicationSources(MedicationFilter.OUTPATIENT);
		filter.addActiveStatus(true);
                Medications results = fetchMedications(patientIdentifier, filter, ScopeFilter.getInstanceForScope(scope), u);
                return results;

        }

	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("outpatient/system/{system-id}")
	public Medications fetchOutpatientMedicationsBySystem(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemIdentifier, @Context UriInfo u,
			@Context HttpHeaders headers) {
        
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		MedicationFilter filter = MedicationFilterFactory.createFilterFromUri(u.getRequestUri());
		filter.addMedicationSources(MedicationFilter.OUTPATIENT);
		Medications results = fetchMedications(patientIdentifier, filter, ScopeFilter.getInstanceForSystem(systemIdentifier), u);
                return results;

        }

	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("outpatient/system/{system-id}/active")
	public Medications fetchCurrentOutpatientMedicationsBySystem(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemIdentifier, @Context UriInfo u,
			@Context HttpHeaders headers) {
        
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		MedicationFilter filter = MedicationFilterFactory.createFilterFromUri(u.getRequestUri());
		filter.addMedicationSources(MedicationFilter.OUTPATIENT);
		filter.addActiveStatus(true);
                Medications results = fetchMedications(patientIdentifier, filter, ScopeFilter.getInstanceForSystem(systemIdentifier), u);
                return results;

	}

	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("inpatient")
	public Medications fetchinpatientMedications(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @Context UriInfo u, @Context HttpHeaders headers) {
        
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		MedicationFilter filter = MedicationFilterFactory.createFilterFromUri(u.getRequestUri());
		filter.addMedicationSources(MedicationFilter.INPATIENT);
                Medications results = fetchMedications(patientIdentifier, filter, ScopeFilter.getInstanceForLongitudinalScope(), u);
                return results;

        }

	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("inpatient/active")
	public Medications fetchCurrentinpatientMedications(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @Context UriInfo u, @Context HttpHeaders headers) {
        
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		MedicationFilter filter = MedicationFilterFactory.createFilterFromUri(u.getRequestUri());
		filter.addMedicationSources(MedicationFilter.INPATIENT);
		filter.addActiveStatus(true);
                Medications results = fetchMedications(patientIdentifier, filter, ScopeFilter.getInstanceForLongitudinalScope(), u);
                return results;

        }

	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("inpatient/scope/{scope}")
	public Medications fetchinpatientMedicationsByScope(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("scope") String scope, @Context UriInfo u, @Context HttpHeaders headers) {
        
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		MedicationFilter filter = MedicationFilterFactory.createFilterFromUri(u.getRequestUri());
		filter.addMedicationSources(MedicationFilter.INPATIENT);
                Medications results = fetchMedications(patientIdentifier, filter, ScopeFilter.getInstanceForScope(scope), u);
                return results;

        }

	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("inpatient/scope/{scope}/active")
	public Medications fetchCurrentinpatientMedicationsByScope(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("scope") String scope, @Context UriInfo u, @Context HttpHeaders headers) {
        
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		MedicationFilter filter = MedicationFilterFactory.createFilterFromUri(u.getRequestUri());
		filter.addMedicationSources(MedicationFilter.INPATIENT);
		filter.addActiveStatus(true);
                Medications results = fetchMedications(patientIdentifier, filter, ScopeFilter.getInstanceForScope(scope), u);
                return results;

        }

	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("inpatient/system/{system-id}")
	public Medications fetchinpatientMedicationsBySystem(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemIdentifier, @Context UriInfo u,
			@Context HttpHeaders headers) {
        
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		MedicationFilter filter = MedicationFilterFactory.createFilterFromUri(u.getRequestUri());
		filter.addMedicationSources(MedicationFilter.INPATIENT);
                Medications results = fetchMedications(patientIdentifier, filter, ScopeFilter.getInstanceForSystem(systemIdentifier), u);
                return results;

        }

	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("inpatient/system/{system-id}/active")
	public Medications fetchCurrentinpatientMedicationsBySystem(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemIdentifier, @Context UriInfo u,
			@Context HttpHeaders headers) {
        
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		MedicationFilter filter = MedicationFilterFactory.createFilterFromUri(u.getRequestUri());
		filter.addMedicationSources(MedicationFilter.INPATIENT);
		filter.addActiveStatus(true);
                Medications results = fetchMedications(patientIdentifier, filter, ScopeFilter.getInstanceForSystem(systemIdentifier), u);
                return results;

        }

	private Medications fetchMedications(PatientIdentifier patientIdentifier, MedicationFilter filter, ScopeFilter scopeFilter, UriInfo uriInfo) {
		MedicationDataService dataservice = new MedicationDataService();
		Medications medications = dataservice.fetchPatientMedications(patientIdentifier, filter, scopeFilter);

		if (uriInfo != null) {
			MedicationLinkBuilder linkBuilder = new MedicationLinkBuilder(uriInfo.getBaseUri());
			linkBuilder.fillLinks(medications, uriInfo.getRequestUri());
		}

		return medications;
	}

	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("system/{system-id}/id/{id}")
	public Medication getMedication(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemId, @PathParam("id") String id, @Context UriInfo u,
			@Context HttpHeaders headers) {
        
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		final DataIdentifier dataIdentifier = new DataIdentifier(systemId, id);

		Medication result = fetchMedication(patientIdentifier, dataIdentifier, u);

                return result;

        }

	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("system/{system-id}/id/{id}/detail")
	public Medication getMedicationDetail(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemId, @PathParam("id") String id, @Context UriInfo u,
			@Context HttpHeaders headers) {
        

		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		final DataIdentifier dataIdentifier = new DataIdentifier(systemId, id);

		Medication result = fetchMedication(patientIdentifier, dataIdentifier, u);

                return result;
        }

	private Medication fetchMedication(final PatientIdentifier patientIdentifier, final DataIdentifier dataIdentifier, UriInfo u) {
		MedicationDataService dataservice = new MedicationDataService();
		Medication medication = dataservice.retrieveMedicationDetail(patientIdentifier, dataIdentifier);

		MedicationLinkBuilder linkBuilder = new MedicationLinkBuilder(u.getBaseUri());
		linkBuilder.fillLinks(medication, u.getRequestUri());

		return medication;
	}
}
