package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.exercise.ExerciseDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Exercise;
import com.agilex.healthcare.mobilehealthplatform.domain.Exercises;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.ExerciseLinkBuilder;

@Path("/patient/{assigning-authority}/{patient-id}/exercise")
@Component
@Scope("request")
public class PatientExercisesResource extends AbstractJournalResource<Exercises, Exercise> {

	public PatientExercisesResource() {
		super(new ExerciseDataService(), Exercise.class);
	}

	@Override
	protected void fillLinks(Exercises datalist, UriInfo u) {
		ExerciseLinkBuilder builder = new ExerciseLinkBuilder(u.getBaseUri());
		builder.fillLinks(datalist, u.getRequestUri());
	}

	@Override
	protected void fillLinks(Exercise data, UriInfo u) {
		ExerciseLinkBuilder builder = new ExerciseLinkBuilder(u.getBaseUri());
		builder.fillLinks(data, u.getRequestUri());
	}
}
