package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.diet.DietDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.DietEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.DietEntry;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.DietLinkBuilder;

@Path("/patient/{assigning-authority}/{patient-id}/diet")
@Component
@Scope("request")
public class PatientDietsResource extends AbstractJournalResource<DietEntries, DietEntry> {

	public PatientDietsResource() {
		super(new DietDataService(), DietEntry.class);
	}

	@Override
	protected void fillLinks(DietEntries datalist, UriInfo u) {
		DietLinkBuilder linkbuilder = new DietLinkBuilder(u.getBaseUri());
		linkbuilder.fillLinks(datalist, u.getRequestUri());
	}

	@Override
	protected void fillLinks(DietEntry data, UriInfo u) {
		DietLinkBuilder linkbuilder = new DietLinkBuilder(u.getBaseUri());
		linkbuilder.fillLinks(data, u.getRequestUri());
	}

}
