package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.contactlog.ContactLogDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.ContactLog;
import com.agilex.healthcare.mobilehealthplatform.domain.ContactLogs;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.ContactLogLinkBuilder;

@Path("/patient/{assigning-authority}/{patient-id}/contactLogs")
@Component
@Scope("request")
public class PatientContactLogsResource extends AbstractJournalResource<ContactLogs, ContactLog> {

	public PatientContactLogsResource() {
		super(new ContactLogDataService(), ContactLog.class);
	}

	@Override
	protected void fillLinks(ContactLogs datalist, UriInfo u) {
		ContactLogLinkBuilder builder = new ContactLogLinkBuilder(u.getBaseUri());
		builder.fillLinks(datalist, u.getRequestUri());
	}

	@Override
	protected void fillLinks(ContactLog data, UriInfo u) {
		ContactLogLinkBuilder builder = new ContactLogLinkBuilder(u.getBaseUri());
		builder.fillLinks(data, u.getRequestUri());
	}

}
