package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.allergy.AllergyDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.AllergyLinkBuilder;

@Path("/patient/{assigning-authority}/{patient-id}/allergies")
@Component
@Scope("request")
public class PatientAllergiesResource {

	/**
	 * Deprecated
	 */
	@GET
	@Produces({ "application/xml", "application/json" })
	@Deprecated
	public Allergies fetchAllergies(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @Context UriInfo u, @Context HttpHeaders headers) {
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		return fetchAllergies(patientIdentifier, ScopeFilter.getInstanceForLongitudinalScope(), u);
	}

	/**
	 * Retrieves patient {@link Allergies} from the configured data source based upon the scope given {longitudinal, operational}
	 *  
	 * @param assigningAuthority
	 * @param patientId
	 * @param scope
	 * @return {@link Allergies}
	 */
	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("scope/{scope}")
	public Allergies fetchAllergiesByScope(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("scope") String scope, @Context UriInfo u, @Context HttpHeaders headers) {
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		return fetchAllergies(patientIdentifier, ScopeFilter.getInstanceForScope(scope), u);
	}

	/**
	 * Retrieves {@link Allergies} by system
	 * 
	 * @param assigningAuthority
	 * @param patientId
	 * @param systemIdentifier
	 * @return {@link Allergies}
	 */
	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("system/{system-id}")
	public Allergies fetchAllergiesBySystem(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemIdentifier, @Context UriInfo u, @Context HttpHeaders headers) {
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		return fetchAllergies(patientIdentifier, ScopeFilter.getInstanceForSystem(systemIdentifier), u);
	}

	/**
	 * This is the self link of a specific Allergy object.
	 * 
	 * @param assigningAuthority
	 * @param patientId
	 * @param systemId
	 * @param id
	 * @return {@link Allergy}
	 */
	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("system/{system-id}/id/{id}")
	public Allergy fetchAllergy(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemId, @PathParam("id") String id, @Context UriInfo u,
			@Context HttpHeaders headers) {
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		final DataIdentifier dataIdentifier = new DataIdentifier(systemId, id);

		AllergyDataService dataService = new AllergyDataService();
		Allergy allergy = dataService.fetchAllergy(patientIdentifier, dataIdentifier);

		AllergyLinkBuilder linkbuilder = new AllergyLinkBuilder(u.getBaseUri());
		linkbuilder.fillLinks(allergy, u.getRequestUri());

		if (allergy == null)
			throw ExceptionFactory.generateNoDataFoundException();

		return allergy;
	}

	private Allergies fetchAllergies(final PatientIdentifier patientIdentifier, ScopeFilter scopeFilter, UriInfo uriInfo) {
		DateFilter dateFilter = DateFilterFactory.createFilterFromUri(uriInfo);
		
		AllergyDataService dataService = new AllergyDataService();
		Allergies allergies = dataService.fetchPatientAllergies(patientIdentifier, dateFilter, scopeFilter);

		return allergies;
	}

}
