package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.admission.AdmissionDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.AdmissionLinkBuilder;

@Path("/patient/{assigning-authority}/{patient-id}/admissions")
@Component
@Scope("request")
public class PatientAdmissionsResource {
	// admissions.sortByDate();

	/**
	 * Deprecated
	 */
	@GET
	@Produces({ "application/xml", "application/json" })
	@Deprecated
	public Admissions fetchAdmissions(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @Context UriInfo u, @Context HttpHeaders headers) {
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		DateFilter dateFilter = DateFilterFactory.createFilterFromUri(u.getRequestUri());
		Admissions results = fetchAdmissions(patientIdentifier, dateFilter, ScopeFilter.getInstanceForLongitudinalScope(), u);
                return results;

        }

	/**
	 * Retrieves {@link Admissions} by scope
	 * 
	 * This method takes date filter query parameters
	 * 
	 * @param assigningAuthority
	 * @param patientId
	 * @param scope {longitudinal, operational}
	 * @return {@link Admissions}
	 */
	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("scope/{scope}")
	public Admissions fetchAdmissionsByScope(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("scope") String scope, @Context UriInfo u, @Context HttpHeaders headers) {
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		DateFilter dateFilter = DateFilterFactory.createFilterFromUri(u.getRequestUri());
                Admissions results = fetchAdmissions(patientIdentifier, dateFilter, ScopeFilter.getInstanceForScope(scope), u);
                return results;

        }

	/**
	 * Retrieves {@link Admissions} by system
	 * 
	 * This method takes date filter query parameters
	 * 
	 * @param assigningAuthority
	 * @param patientId
	 * @param systemIdentifier
	 * @return {@link Admissions}
	 */
	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("system/{system-id}")
	public Admissions fetchAdmissionsBySystem(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemIdentifier, @Context UriInfo u, @Context HttpHeaders headers) {
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		DateFilter dateFilter = DateFilterFactory.createFilterFromUri(u.getRequestUri());
		Admissions results = fetchAdmissions(patientIdentifier, dateFilter, ScopeFilter.getInstanceForSystem(systemIdentifier), u);
		return results;

        }   

	/**
	 * Retrieves a single {@link Admission}. 
	 * 
	 * This is the self-link of an admission record
	 * 
	 * @param assigningAuthority
	 * @param patientId
	 * @param systemId
	 * @param id
	 * @return {@link Admission}
	 */
	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("system/{system-id}/id/{id}")
	public Admission fetchAdmission(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemId, @PathParam("id") String id, @Context UriInfo u,
			@Context HttpHeaders headers) {
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		final DataIdentifier dataIdentifier = new DataIdentifier(systemId, id);
		AdmissionDataService dataService = new AdmissionDataService();
		Admission admission = dataService.getPatientAdmission(patientIdentifier, dataIdentifier);

		AdmissionLinkBuilder linkbuilder = new AdmissionLinkBuilder(u.getBaseUri());
		linkbuilder.fillLinks(admission, u.getRequestUri());

		
		if (admission == null)
			throw ExceptionFactory.generateNoDataFoundException();
		
                return admission;
	}
	
	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("system/{system-id}/id/{id}/note")
	public ProviderNote fetchDischargeNote(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemId, @PathParam("id") String id, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
		PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		DataIdentifier dataIdentifier = new DataIdentifier(systemId, id);
		DateFilter dateFilter = DateFilterFactory.createFilterFromUri(uriInfo);
		
		AdmissionDataService admissionDataService = new AdmissionDataService();
		ProviderNote dischargeNote = admissionDataService.fetchDischargeNoteForInpatientDateRange(patientIdentifier, dataIdentifier, dateFilter);
		
		return dischargeNote;		
	}

	private Admissions fetchAdmissions(final PatientIdentifier patientIdentifier, DateFilter dateFilter, ScopeFilter scopeFilter, UriInfo u) {
		AdmissionDataService dataService = new AdmissionDataService();
		Admissions admissions = dataService.getPatientAdmissions(patientIdentifier, dateFilter, scopeFilter);

		admissions.sortByDate();

		AdmissionLinkBuilder linkbuilder = new AdmissionLinkBuilder(u.getBaseUri());
		linkbuilder.fillLinks(admissions, u.getRequestUri());

		return admissions;
	}
}
