package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.pain.PainDiaryEntryDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.PainDiaryEntryLinkBuilder;

@Path("/patient/{assigning-authority}/{patient-id}/pain-diary")
@Component
@Scope("request")
public class PainDiaryResource {

	@GET
	@Produces({ "application/xml", "application/json" })
	public PainDiaryEntries fetchPainDiaryEntries(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @Context UriInfo u, @Context HttpHeaders headers) {
		return fetchPainDiaryEntries(assigningAuthority, patientId, null, u, headers);
	}

	public PainDiaryEntries fetchPainDiaryEntries(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, DateFilter dateFilter, @Context UriInfo u, @Context HttpHeaders headers) {
		
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		
		PainDiaryEntryDataService dataService = new PainDiaryEntryDataService();
		PainDiaryEntries painEntries = dataService.fetchPainDiaryEntries(patientIdentifier, dateFilter);

		PainDiaryEntryLinkBuilder linkbuilder = new PainDiaryEntryLinkBuilder(u.getBaseUri());
		linkbuilder.fillLinks(painEntries, u.getRequestUri());
		
		return painEntries;
	}
	
	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("system/{system-id}/id/{id}")
	public PainDiaryEntry fetchPainDiaryEntry(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @PathParam("system-id") String systemId, @PathParam("id") String id, @Context UriInfo u, @Context HttpHeaders headers) {
		
		final PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		final DataIdentifier dataIdentifier = new DataIdentifier(systemId, id);

		PainDiaryEntryDataService dataService = new PainDiaryEntryDataService();
		PainDiaryEntry painEntry = dataService.fetchPainDiaryEntry(patientIdentifier, dataIdentifier);

		PainDiaryEntryLinkBuilder linkbuilder = new PainDiaryEntryLinkBuilder(u.getBaseUri());
		linkbuilder.fillLinks(painEntry, u.getRequestUri());
		
		if (painEntry == null) {
			throw ExceptionFactory.generateNoDataFoundException();
		}
		
		return painEntry;
	}
	
	@POST
	@Produces({ "application/xml", "application/json" })
	@Consumes({ "application/xml", "application/json" })
	public PainDiaryEntry createNewPainDiaryEntry(PainDiaryEntry painDiaryEntry, @PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @Context UriInfo u, @Context HttpHeaders headers) {
		PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		painDiaryEntry.setPatientIdentifier(patientIdentifier);

		PainDiaryEntryDataService dataService = new PainDiaryEntryDataService();
		PainDiaryEntry createdPainDiaryEntry = dataService.createNewPainDiaryEntry(painDiaryEntry);

		if (u != null) {
			PainDiaryEntryLinkBuilder linkBuilder = new PainDiaryEntryLinkBuilder(u.getBaseUri());
			linkBuilder.fillLinks(createdPainDiaryEntry, u.getRequestUri());
		}

		return createdPainDiaryEntry;
	}
	
	@PUT
	@Produces({ "application/xml", "application/json" })
	@Consumes({ "application/xml", "application/json" })
	@Path("system/{system-id}/id/{id}")
	public PainDiaryEntry updatePainDiaryEntry(PainDiaryEntry painDiaryEntry, @PathParam("assigning-authority") String assigningAuthority,
			@PathParam("patient-id") String patientId, @PathParam("system-id") String systemId, @PathParam("id") String id, @Context UriInfo u, @Context HttpHeaders headers) {
		PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		final DataIdentifier dataIdentifier = new DataIdentifier(systemId, id);
		painDiaryEntry.setPatientIdentifier(patientIdentifier);

		PainDiaryEntryDataService dataService = new PainDiaryEntryDataService();
		PainDiaryEntry updatedPainDiaryEntry = dataService.updatePainDiaryEntry(patientIdentifier, dataIdentifier, painDiaryEntry);

		if (u != null) {
			PainDiaryEntryLinkBuilder linkBuilder = new PainDiaryEntryLinkBuilder(u.getBaseUri());
			linkBuilder.fillLinks(updatedPainDiaryEntry, u.getRequestUri());
		}

		return updatedPainDiaryEntry;
	}
	
		
}