package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.NotificationUserDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.NotificationUsers;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.NotificationUserUriHelper;
import com.agilex.healthcare.utility.NullChecker;

@Path("/notification-service/users")
@Component
@Scope("request")
public class NotificationUserResource {

	/***
	 * A resource that returns all users who satisfy this search parameter and are eligible to have notifications sent to them. 
	 * @param searchString
	 * The search string, such as patient's name, that uniquely identifies this user
	 * @return
	 * All {@link NotificationUsers} that satisfy this search parameter
	 */
	@GET
	@Produces({ "application/xml", "application/json" })
	public NotificationUsers getUsers(@QueryParam("searchstring") String searchString, @QueryParam("siteCode") String siteCode, 
			@Context UriInfo uriInfo) {
		
		if (NullChecker.isNullish(searchString) || NullChecker.isNullish(siteCode)) {
			throw new WebApplicationException(Status.BAD_REQUEST);
		}

		NotificationUserDataService notificationUserDataService = new NotificationUserDataService();
		NotificationUsers notificationUsers = notificationUserDataService.searchNotificationUsers(searchString, siteCode);

		if(uriInfo != null) {
			NotificationUserUriHelper.updateNotificationUsersLinks(notificationUsers, uriInfo);
		}
		
		return notificationUsers;
	}
}
