package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.NotificationDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Property;
import com.agilex.healthcare.mobilehealthplatform.utils.PropertyHelper;

@Component
@Scope("request")
@Path("/notification-service/opt-out")
public class NotificationOptOutStatusResource {
	
	@Resource
	private PropertyHelper propertyHelper;

	@GET
	@Path("/enabled")
	@Produces("text/plain")
	public String isOptOutEnabled() {
		NotificationDataService dataService = new NotificationDataService(propertyHelper);
		Property notificationStatus = dataService.fetchNotificationStatus();
		
		return notificationStatus.getValue();
	}
}
