package com.agilex.healthcare.mobilehealthplatform.restservice;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.MygoalsURIs;
import com.agilex.healthcare.mobilehealthplatform.domain.MygoalsURI;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.PatientDataLinkBuilder;

public class MygoalsURILinkBuilder extends PatientDataLinkBuilder<MygoalsURIs, MygoalsURI> {

	public MygoalsURILinkBuilder(URI baseUri) {	
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(MygoalsURI dataItem) {
		return UriBuilder.fromUri((getBaseUri())).path("patient").path(dataItem.getPatientIdentifier().getAssigningAuthority()).path(dataItem.getPatientIdentifier().getUniqueId()).path(Domain.mygoals).build();
	}

	@Override
	protected void fillCustomRelatedLinks(MygoalsURI dataItem) {
		URI mygoalsBaseUri = UriBuilder.fromUri((getBaseUri())).path("patient").path(dataItem.getPatientIdentifier().getAssigningAuthority()).path(dataItem.getPatientIdentifier().getUniqueId()).path(Domain.mygoals).build();
		
		dataItem.getLink().addRelatedLink("latest", UriBuilder.fromUri(mygoalsBaseUri).path("latest").build());
		dataItem.getLink().addRelatedLink("report", UriBuilder.fromUri(mygoalsBaseUri).path("report").build());
		dataItem.getLink().addRelatedLink("all", UriBuilder.fromUri(mygoalsBaseUri).path("all").build());
	}

	@Override
	protected void fillCustomRelatedLinks(MygoalsURIs dataList) {}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return null;
	}

}
