package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentRequestDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.facility.FacilityDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.facility.FacilityFilter;
import com.agilex.healthcare.mobilehealthplatform.datalayer.facility.FacilityFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.PilotFacilitiesHelper;

@Path("/facility-service/")
@Component
@Scope("request")
public class FacilityResource {
	@Resource
	PilotFacilitiesHelper pilotFacilitiesHelper;
	
	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("facilities")
	public Facilities fetchFacilities(@Context UriInfo uriInfo, @Context HttpServletRequest request, @Context HttpHeaders headers, @QueryParam("app") String app) {
		FacilityFilterFactory facilityFilterFactory = new FacilityFilterFactory(pilotFacilitiesHelper.getPilotSites(app));
		FacilityFilter filter = facilityFilterFactory.createFromUri(uriInfo.getRequestUri());
		FacilityDataService dataService = new FacilityDataService();
		return dataService.fetchFacilities(filter);
	}
	
	@GET
	@Produces({ "application/xml", "application/json" })
	@Path("/patient/{assigning-authority}/{patient-id}/facilities")
	public Facilities fetchMostRecentFacilities(@Context UriInfo uriInfo, @Context HttpServletRequest request, @Context HttpHeaders headers, @PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId) {
		PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		
		AppointmentRequestDataService appointmentRequestDataService = new AppointmentRequestDataService();
		return appointmentRequestDataService.fetchMostRecentFacilities(patientIdentifier, ScopeFilter.getInstanceForLongitudinalScope());
	}
	
}
