package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.customview.CustomViewDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.CustomView;
import com.agilex.healthcare.mobilehealthplatform.domain.CustomViewList;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

@Component
@Scope("request")
@Path("patient/{assigning-authority}/{patient-id}/customview")
public class CustomViewResource {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(CustomViewResource.class);
	private final CustomViewDataService dataService = new CustomViewDataService();
	private static final ScopeFilter scope = ScopeFilter.getInstanceForLongitudinalScope();

	/**
	 * Retrieves the {@link CustomViewList}
	 * 
	 * @param assigningAuthority
	 * @param patientId
	 */
	@GET
	@Produces({ "application/xml", "application/json" })
	public CustomViewList fetchCustomViewList(@PathParam("patient-id") String patientId, @PathParam("assigning-authority") String assigningAuthority,
			@Context UriInfo uriInfo, @Context HttpHeaders headers) {
		
		logger.debug("CustomViewResource.fetchCustomViewData() called");
		PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);
		CustomViewList customviews = dataService.fetchCustomViews(patientIdentifier, scope);
		setIdentifiersAndLinks(customviews, patientIdentifier, uriInfo);

		return customviews;
	}

	
	private void setIdentifiersAndLinks(CustomViewList customviews, PatientIdentifier patientIdentifier, UriInfo uriInfo) {
		CustomViewLinkBuilder linkBuilder = new CustomViewLinkBuilder(uriInfo.getBaseUri());
		for (CustomView customView : customviews) {
			customView.setPatientIdentifier(patientIdentifier);
			DataIdentifier customViewDataIdentifier = new DataIdentifier(patientIdentifier.getAssigningAuthority(), patientIdentifier.getUniqueId());
			customView.setDataIdentifier(customViewDataIdentifier);
			linkBuilder.fillLinks(customView, uriInfo.getRequestUri());
			
		}
		
	}

}
