package com.agilex.healthcare.mobilehealthplatform.restservice;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.CustomView;
import com.agilex.healthcare.mobilehealthplatform.domain.CustomViewList;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder.PatientDataLinkBuilder;

public class CustomViewLinkBuilder extends PatientDataLinkBuilder<CustomViewList, CustomView> {

	public CustomViewLinkBuilder(URI baseUri) {	
		super(baseUri);
	}

	@Override
	public URI get      icalSelfUri(CustomView dataItem) {
		return UriBuilder.fromUri((getBaseUri())).path("patient").path(dataItem.getPatientIdentifier().getAssigningAuthority()).path(Domain.mygoals).build();
	}

	@Override
	protected void fillCustomRelatedLinks(CustomView dataItem) {
		URI mygoalsBaseUri = UriBuilder.fromUri((getBaseUri())).path("patient").path(dataItem.getPatientIdentifier().getAssigningAuthority()).path(dataItem.getPatientIdentifier().getUniqueId()).path(Domain.mygoals).build();
		
		dataItem.getLink().addRelatedLink("latest", UriBuilder.fromUri(mygoalsBaseUri).path("latest").build());
		dataItem.getLink().addRelatedLink("report", UriBuilder.fromUri(mygoalsBaseUri).path("report").build());
	}

	@Override
	protected void fillCustomRelatedLinks(CustomViewList dataList) {}

	@Override
	public URI get      icalUriForCollection(URI patientUri) {
		return null;
	}

}
