package com.agilex.healthcare.mobilehealthplatform.restservice;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;

@Path("/clinic")
@Component
@Scope("request")
public class ClinicAppointmentsResource {

	@GET
	@Produces({ "text/calendar" })
	@Path("{id}/appointments")
	public String getClinicAppointmentsAsIcsById(@PathParam("id") String clinicId, @Context UriInfo u, @Context HttpHeaders headers) {
		AppointmentDataService appointmentsDataService = new AppointmentDataService();

		DateFilter datefilter = DateFilterFactory.createCalendarApplicationDateFilter(u.getRequestUri());
		Appointments clinicAppointments = appointmentsDataService.getClinicAppointments(clinicId, datefilter);
		String ics = appointmentsDataService.createIcsFromAppointments(clinicAppointments);

		return ics;
	}

}
