package com.agilex.healthcare.mobilehealthplatform.pdf;


import com.agilex.healthcare.pdf.AbstractPage;
import com.agilex.healthcare.pdf.PDFException;
import com.agilex.healthcare.pdf.PageEvent;
import com.agilex.healthcare.pdf.PdfGenerationContext;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;

import java.util.List;

public class PatientEnteredVitalsPage extends AbstractPage {
    private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(PatientEnteredVitalsPage.class);

    public PatientEnteredVitalsPage(Document document, PageEvent event, PdfWriter writer, PdfGenerationContext context) {
        super(document, event, writer, context);
    }

    public void create() {
        try {
            setupReportHeaders(context);
            addHeading(context.getReportHeading(), "Heading");
            addGeneratedFor();
            addGenerationTime();

            addDateRange(context.getDateFilter());

            List<List<String>> data = context.getReportDataTable();
            if(data == null || data.size() == 0) {
                addNoDataFound();
                return;
            }

            PdfPTable table = createDataTable();
            document.add(table);
        } catch (DocumentException e) {
            logger.error("Error in creating PatientEnteredVitalsPage", e);
            throw new PDFException("Error generating PDF PatientEnteredVitalsPage ");
        }
    }

    private void setupReportHeaders(PdfGenerationContext context) {
        String section = context.getSection();

        if(section.equals("BP")) {
            context.setReportHeading("Blood Pressure and Pulse Summary - From My VA Health");
            context.setColumnWidths(new int[] {25, 25, 38, 20, 25});
            context.setColumnHeaders(new String[]
                {"Date", "Time", "Blood Pressure (mmHg)", "Pulse (bpm)", "Position"});
        } else if(section.equals("weight")) {
            context.setReportHeading("Weight Summary - From My VA Health");
            context.setColumnWidths(new int[] {20, 20, 25});
            context.setColumnHeaders(new String[] {"Date", "Time", "Weight (lbs)"});
        }
    }
}
