package com.agilex.healthcare.mobilehealthplatform.pdf;

import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalObservation;
import com.agilex.healthcare.utility.DateHelper;

import java.util.ArrayList;
import java.util.List;

public class PatientEnteredVitalsMapper {
    public static String dateFormat = "MM/dd/yyyy";
    public static String timeFormat = "hh:mm a";

    public static List<List<String>> getBloodPressureTable (VitalEntries vitalEntries) {
        List<List<String>> table = new ArrayList<List<String>>();

        for(VitalEntry vitalEntry : vitalEntries) {
            List observations = vitalEntry.getVitalObservations();
            List<String> row = new ArrayList<String>();

            String bloodPressure = ((VitalObservation) observations.get(0)).getValue() + "/" +
                ((VitalObservation) observations.get(1)).getValue();
            String pulse = ((VitalObservation) observations.get(2)).getValue();

            row.add(DateHelper.format(vitalEntry.getDate(), dateFormat));
            row.add(DateHelper.format(vitalEntry.getDate(), timeFormat));
            row.add(bloodPressure);
            row.add(pulse);
            row.add(vitalEntry.getQualifier());

            table.add(row);
        }
        return table;
    }

    public static List<List<String>> getWeightTable(VitalEntries vitalEntries) {
        List<List<String>> table = new ArrayList<List<String>>();

        for(VitalEntry vitalEntry : vitalEntries) {
            List observations = vitalEntry.getVitalObservations();
            List<String> row = new ArrayList<String>();
            row.add(DateHelper.format(vitalEntry.getDate(), dateFormat));
            row.add(DateHelper.format(vitalEntry.getDate(), timeFormat));
            row.add(((VitalObservation) observations.get(0)).getValue());

            table.add(row);
        }
        return table;
    }
}
