package com.agilex.healthcare.mobilehealthplatform.pdf;

import com.agilex.healthcare.pdf.AbstractPage;
import com.agilex.healthcare.pdf.PageEvent;
import com.agilex.healthcare.pdf.PdfGenerationContext;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfWriter;

public class MhpPdfPageFactory {
    public static AbstractPage createPage(Document document, PageEvent event, PdfWriter writer, PdfGenerationContext context) {
        String section = context.getSection();

        if(section.equals("BP")) {
            return new PatientEnteredVitalsPage(document, event, writer, context);
        } else if(section.equals("weight")) {
            return new PatientEnteredVitalsPage(document, event, writer, context);
        } else if(section.equals("event")) {
            return new DailyEventPage(document, event, writer, context);
        }
        return null;
    }
}
