package com.agilex.healthcare.mobilehealthplatform.datalayer;

import com.agilex.healthcare.mobilehealthplatform.pdf.MhpPdfPageFactory;
import com.agilex.healthcare.pdf.AbstractPage;
import com.agilex.healthcare.pdf.PageEvent;
import com.agilex.healthcare.pdf.PdfGenerationContext;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfWriter;

import org.apache.log4j.Logger;

import java.awt.*;
import java.io.OutputStream;

public class PdfDataLayerItext implements PdfDataLayer {
    private static final Logger LOGGER = Logger.getLogger(PdfDataLayerItext.class);
    Document document;

    public PdfDataLayerItext() {
        initializeDocument();
    }

    private void initializeDocument() {
        Rectangle pageSize = new Rectangle(PageSize.A4);
        pageSize.setBackgroundColor(new BaseColor(0xFF, 0xFF, 0xFF));
        document = new Document(pageSize);
        document.setMargins(60, 45, 60, 45);
    }

    public void generateReport(OutputStream outputStream, PdfGenerationContext context) throws DocumentException {
        PageEvent event = new PageEvent(context);
        PdfWriter writer = PdfWriter.getInstance(document, outputStream);
        writer.setLinearPageMode();
        writer.setPageEvent(event);

        document.open();
        AbstractPage page = MhpPdfPageFactory.createPage(document, event, writer, context);
        page.create();
        document.close();
    }
}
