package com.agilex.healthcare.mbb.roa;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

import javax.imageio.ImageIO;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.StreamHelper;

public class ROAImageGenerator {
	private static final String RESOURCES_LOCATION = "com/agilex/healthcare/mobilehealthplatform/roa/";
	
    public BufferedImage generate(MhpUser mhpUser) throws IOException {
    	InputStream roaImageAsStream = null;
    	try {
    		roaImageAsStream = this.getClass().getClassLoader().getResourceAsStream(RESOURCES_LOCATION + "template.png");
	    	BufferedImage template = ImageIO.read(roaImageAsStream);
	        int w = template.getWidth();
	        int h = template.getHeight();
	        BufferedImage generatedForm = new BufferedImage(w, h, BufferedImage.TYPE_INT_ARGB);
	        
	        Graphics2D g2d = generatedForm.createGraphics();
	        g2d.drawImage(template, 0, 0, null);
	        g2d.setPaint(Color.black);
	        
	        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
	        g2d.setFont(new java.awt.Font("monospaced", Font.PLAIN, 15));
	
	        addPatientData(mhpUser, g2d);
	        
	        Date now = new Date();
	        String date = DateHelper.formatDate(now);
	        g2d.drawString(date, 617, 944);
	        
	        g2d.dispose();
	        
	        return generatedForm;
    	} finally {
    		StreamHelper.safeClose(roaImageAsStream);
    	}
    }

    private void addPatientData(MhpUser mhpUser, Graphics2D g2d) {
        g2d.drawString(buildName(mhpUser.getPatientLastName(), mhpUser.getPatientFirstName(), mhpUser.getPatientMiddleName()), 70, 448);
        g2d.drawString(mhpUser.getPatientDateOfBirth(), 670, 448);
    }

    private String buildName(String lastName, String firstName, String middleInitial) {
    	StringBuilder name = new StringBuilder(lastName);
        name.append(", ");
        name.append(firstName);
        
        if (NullChecker.isNotNullish(middleInitial)) {
        	name.append(" ");
        	name.append(middleInitial);
        }
        
        return name.toString();
    }
}
