package com.agilex.healthcare.mbb.restservice;

import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mobilehealthplatform.datalayer.launchpad.LaunchpadDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentsMetadata;
import com.agilex.healthcare.mobilehealthplatform.domain.LaunchpadItem;
import com.agilex.healthcare.mobilehealthplatform.domain.LaunchpadMetadata;
import com.agilex.healthcare.mobilehealthplatform.restservice.AbstractUserResource;
import com.sun.jersey.api.NotFoundException;


@Path("/public/launchpad")
@Component
@Scope("request")
public class LaunchpadResource extends AbstractUserResource {
	
	@Resource
	AppointmentsMetadata appointmentsMetadata;

	@Resource
	private String haMode;
	
	@GET
	@Path("/metadata")
	@Produces({ "application/xml", "application/json" })
	public LaunchpadMetadata getLaunchpadMetadata(@Context UriInfo uriInfo) {
		LaunchpadDataService dataService = new LaunchpadDataService();
		return dataService.fetchLaunchpadMetadata(haMode);
	}
	
	@GET
	@Path("/launchpadItem")
	@Produces({"application/xml", "application/json" })
	public LaunchpadItem getLaunchpadItemByUrl(@QueryParam("appUrl") String appUrl, @Context UriInfo uriInfo) {
		LaunchpadDataService dataService = new LaunchpadDataService();
		LaunchpadItem item = dataService.fetchLaunchpadItemByUrl(haMode, appUrl);
		if (item == null) {
			throw new NotFoundException();
		}
		return item;
	}
	
}
