package com.agilex.healthcare.mbb.restservice;

import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.healthcare.mbb.dataservice.ClinicalDomainsDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.ClinicalDomain;
import com.agilex.healthcare.mobilehealthplatform.domain.ClinicalDomains;

@Path("public/domains")
@Component
@Scope("request")
public class ClinicalDomainResource {
	
	@GET
	@Produces({ "application/xml", "application/json" })
	public List<ClinicalDomain> getShareDomains(@Context UriInfo uriInfo) {
		String baseUrl = uriInfo.getBaseUri().toString();
	    
		ClinicalDomainsDataService dataService = new ClinicalDomainsDataService();
		ClinicalDomains shareDomains = dataService.getShareDomains(baseUrl);
		return shareDomains;
	}

}
