package com.agilex.healthcare.mbb.pdf.pages;

import java.util.Date;
import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mbb.pdf.PageEvent;
import com.agilex.healthcare.mbb.pdf.Stylesheet;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalTableData;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalTableRow;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.objectmapper.VitalTableDataGenerator;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;

public class VitalPage extends AbstractPage {

  public VitalPage(Document document, PageEvent event, PdfWriter writer, PdfGenerationContext context) {
    super(document, event, writer, context);
  }

  public void create() throws DocumentException {
    String domain = Domain.vital;
    addHeading(context.getMessageSource().getMessage("mbb.report.vitals.title", null, context.getLocale()), domain);
    addUpdate(context.getMessageSource().getMessage("mbb.report.vitals.updateFrequency", null, context.getLocale()), domain);
    addTextDateRange(context.getDateFilter());
    PdfPTable table = createTable();

    VitalEntries entries = (VitalEntries)context.getInformation(domain);

    if (NullChecker.isNotNullish(entries)) {

      VitalTableDataGenerator tableGenerator = new VitalTableDataGenerator();
      VitalTableData vitalTableData = tableGenerator.generateVitalTableData(entries);

      if( vitalTableData != null ) {

        vitalTableData.sortDescending("entryTime");

        for( int i = 0 ; i < vitalTableData.size( ) ; i++ ) {

          VitalTableRow vitalRow = vitalTableData.get( i ) ;
          if( vitalRow == null ) {

            continue ;
          }

          addVitalEntry(table, vitalRow, i, i == vitalTableData.size( ) - 1 ? true : false );
        }
      }
    } else {
        addNoDataFound();
    }

    document.add(table);
  }

  private PdfPTable createTable() throws DocumentException {
    PdfPTable table = new PdfPTable(8);
    table.setWidthPercentage(100);
    table.setWidths(new int[] { 15, 12, 10, 10, 10, 10, 13, 10 });
    table.setSpacingBefore(10);
    table.setSpacingAfter(10);
    table.setHeaderRows(1);

    PdfPCell cell;
    cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.vitals.date", null, context.getLocale()), false, PdfPTable.ALIGN_LEFT);
    table.addCell(cell);
        cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.vitals.bp", null, context.getLocale()), false, PdfPTable.ALIGN_LEFT);
        table.addCell(cell);
    cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.vitals.pulse", null, context.getLocale()), false, PdfPTable.ALIGN_LEFT);
    table.addCell(cell);
    cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.vitals.weight", null, context.getLocale()), false, PdfPTable.ALIGN_LEFT);
    table.addCell(cell);
    cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.vitals.height", null, context.getLocale()), false, PdfPTable.ALIGN_LEFT);
    table.addCell(cell);
    cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.vitals.temp", null, context.getLocale()), false, PdfPTable.ALIGN_LEFT);
    table.addCell(cell);
    cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.vitals.respRate", null, context.getLocale()), false, PdfPTable.ALIGN_LEFT);
    table.addCell(cell);
    cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.vitals.pain", null, context.getLocale()), true, PdfPTable.ALIGN_LEFT);
    table.addCell(cell);

    return table;
  }

  private void addVitalEntry(PdfPTable table, VitalTableRow row , int rowNum, boolean lastRow) {

    final Date DATE = row.getEntryTime( ) ;
    final String SYSTOLIC = row.getSystolic() ;
    final String DIASTOLIC = row.getDiastolic() ;
    final String PULSE = row.getPulse() ;
    final String WEIGHT = row.getWeight() ;
    final String HEIGHT = row.getHeight() ;
    final String TEMP = row.getTemperature() ;
    final String RESP_RATE = row.getRespiration() ;
    final String PAIN = row.getPain() ;

        final String systolic = NullChecker.isNullish(SYSTOLIC) ? "-" : SYSTOLIC;
        final String diastolic = NullChecker.isNullish(DIASTOLIC) ? "-" : DIASTOLIC;
        final String BP = systolic + "/" + diastolic;

    PdfPCell cell;
    cell = createCell(new Phrase(DateHelper.formatDate(DATE), Stylesheet.getNormal()), rowNum, false, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createCell(new Phrase(BP, Stylesheet.getNormal()), rowNum, false, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createCell(new Phrase(PULSE, Stylesheet.getNormal()), rowNum, false, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createCell(new Phrase(WEIGHT, Stylesheet.getNormal()), rowNum, false, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createCell(new Phrase(HEIGHT, Stylesheet.getNormal()), rowNum, false, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createCell(new Phrase(TEMP, Stylesheet.getNormal()), rowNum, false, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createCell(new Phrase(RESP_RATE, Stylesheet.getNormal()), rowNum, false, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createCell(new Phrase(PAIN, Stylesheet.getNormal()), rowNum, true, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
  }

}
