package com.agilex.healthcare.mbb.pdf.pages;

import java.util.Date;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mbb.pdf.PageEvent;
import com.agilex.healthcare.mbb.pdf.Stylesheet;
import com.agilex.healthcare.mobilehealthplatform.domain.Surgeries;
import com.agilex.healthcare.mobilehealthplatform.domain.Surgery;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;

public class SurgeryPage extends AbstractPage {

  public SurgeryPage(Document document, PageEvent event, PdfWriter writer, PdfGenerationContext context) {
    super(document, event, writer, context);
  }

  public void create() throws DocumentException {
    String domain = Domain.surgery;
    addHeading(context.getMessageSource().getMessage("mbb.report.surgeries.title", null, context.getLocale()), domain);
    addUpdate(context.getMessageSource().getMessage("mbb.report.problems.updateFrequency", null, context.getLocale()), domain);

    PdfPTable table = createTable();

    Surgeries surgeries = (Surgeries)context.getInformation(domain);

    if (NullChecker.isNotNullish(surgeries)) {
      int i = 0;
      for (Surgery  surgery : surgeries) {
        boolean lastRow = (i == (surgeries.size() - 1));
        addSurgery(table, surgery, i++, lastRow);
      }

      document.add(table);
    } else {
      addNoDataFound();
    }
  }

  private PdfPTable createTable() throws DocumentException {
    PdfPTable table = new PdfPTable(3);
    table.setWidthPercentage(100);
    table.setWidths(new int[] { 50, 35, 15 });
    table.setSpacingBefore(10);
    table.setSpacingAfter(10);
    table.setHeaderRows(1);

    PdfPCell cell;
    cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.surgeries.description", null, context.getLocale()), false, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.surgeries.date", null, context.getLocale()), false, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell =  createTableHeader(context.getMessageSource().getMessage("mbb.report.surgeries.facility", null, context.getLocale()), true, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);

    return table;
  }

  private void addSurgery(PdfPTable table, Surgery surgery, int rowNum, boolean lastRow) {
    final String NAME = surgery.getProcedure();
    final Date DATE = surgery.getProcedureDate();
    final String FACILITY = surgery.getFacility();

    PdfPCell cell;
    cell = createCell(new Phrase(NAME, Stylesheet.getNormal()), rowNum, false, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createCell(new Phrase(DateHelper.formatDate(DATE), Stylesheet.getNormal()), rowNum, false, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createCell(new Phrase(FACILITY, Stylesheet.getNormal()), rowNum, true, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
  }
}
