package com.agilex.healthcare.mbb.pdf.pages;

import java.util.Date;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mbb.pdf.PageEvent;
import com.agilex.healthcare.mbb.pdf.Stylesheet;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResult;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResults;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;

public class RadiologyPage extends AbstractPage {
  //private static final Logger LOGGER = Logger.getLogger(RadiologyPage.class);

  public RadiologyPage(Document document, PageEvent event, PdfWriter writer, PdfGenerationContext context) {
    super(document, event, writer, context);
  }

  public void create() throws DocumentException {
    String domain = Domain.radiologyResult;
    addHeading(getMessage("mbb.report.radiology.title", null), domain);
    addUpdate(getMessage("mbb.report.radiology.updateFrequency", null), domain);
    addTextDateRange(context.getDateFilter());

    RadiologyResults results = (RadiologyResults)context.getInformation(domain);

    if (NullChecker.isNotNullish(results)) {
      for (RadiologyResult  result : results) {
        addResult(document, result);
      }
    } else {
      addNoDataFound();
    }
  }

  private Paragraph createReportHeader() throws DocumentException {
    return new Paragraph(getMessage("mbb.report.radiology.radiologyReport", null), Stylesheet.getBoldLarge());
  }

  private void addResult(Document document, RadiologyResult result) throws DocumentException {
    final Date DATE = result.getResultedDate();
    final String EXAM = result.getTestName();
    final String FACILITY = result.getFacilityName();
    final String REPORT = NullChecker.isNullish(result.getReport()) ? getMessage("mbb.report.noReportFound", null) : result.getReport();

    Paragraph header = createReportHeader();
    document.add(header);

    PdfPTable examInformationTable = new PdfPTable(3);
    examInformationTable.setWidthPercentage(100);
    examInformationTable.setWidths(new int[] { 20, 50, 30 });
    examInformationTable.setHeaderRows(1);
    examInformationTable.setSpacingBefore(10);
    examInformationTable.setSpacingAfter(10);
    
    examInformationTable.addCell(createTableHeader(getMessage("mbb.report.radiology.date", null), false, PdfPCell.ALIGN_LEFT));
    examInformationTable.addCell(createTableHeader(getMessage("mbb.report.radiology.exam", null), false, PdfPCell.ALIGN_LEFT));
    examInformationTable.addCell(createTableHeader(getMessage("mbb.report.radiology.facility", null), false, PdfPCell.ALIGN_LEFT));
    
    examInformationTable.addCell(createCell(new Phrase(DateHelper.formatDateTimeNoSeconds(DATE)), 1, false, false, PdfPCell.ALIGN_LEFT));
    examInformationTable.addCell(createCell(new Phrase(EXAM), 1, false, false, PdfPCell.ALIGN_LEFT));
    examInformationTable.addCell(createCell(new Phrase(FACILITY), 1, false, false, PdfPCell.ALIGN_LEFT));
    
    document.add(examInformationTable);

    Paragraph report = new Paragraph(REPORT, Stylesheet.getNormal());
    setupParagraph(report);
    document.add(report);
    addSolidLine();
    addBlankLines(1);
  }
}
