package com.agilex.healthcare.mbb.pdf.pages;

import java.util.Date;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mbb.pdf.PageEvent;
import com.agilex.healthcare.mbb.pdf.Stylesheet;
import com.agilex.healthcare.mobilehealthplatform.domain.Problem;
import com.agilex.healthcare.mobilehealthplatform.domain.Problems;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;

public class ProblemPage extends AbstractPage {

  public ProblemPage(Document document, PageEvent event, PdfWriter writer, PdfGenerationContext context) {
    super(document, event, writer, context);
  }

  public void create() throws DocumentException {
    String domain = Domain.problem;
    addHeading(context.getMessageSource().getMessage("mbb.report.problems.title", null, context.getLocale()), domain);
    addUpdate(context.getMessageSource().getMessage("mbb.report.problems.updateFrequency", null, context.getLocale()), domain);

    PdfPTable table = createTable();

    Problems problems = (Problems)context.getInformation(domain);

    if (NullChecker.isNotNullish(problems)) {
      int i = 0;
      for (Problem  problem : problems) {
        boolean lastRow = (i == (problems.size() - 1));
        addProblem(table, problem, i++, lastRow);
      }

      document.add(table);
    } else {
      addNoDataFound();
    }

  }

  private PdfPTable createTable() throws DocumentException {
    PdfPTable table = new PdfPTable(3);
    table.setWidthPercentage(100);
    table.setWidths(new int[] { 60, 25, 15 });
    table.setSpacingBefore(10);
    table.setSpacingAfter(10);
    table.setHeaderRows(1);

    PdfPCell cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.problems.current", null, context.getLocale()), false, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.problems.date", null, context.getLocale()), false, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.problems.source", null, context.getLocale()), true, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);

    return table;
  }

  private void addProblem(PdfPTable table, Problem problem, int rowNum, boolean lastRow) {
    final String NAME = problem.getDescription();
    final Date ONSET_DATE = problem.getOnsetDate();
    final String SOURCE = problem.getSourceSystem();

    PdfPCell cell;
    cell = createCell(new Phrase(NAME, Stylesheet.getNormal()), rowNum, false, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createCell(new Phrase(DateHelper.formatDate(ONSET_DATE), Stylesheet.getNormal()), rowNum, false, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createCell(new Phrase(SOURCE, Stylesheet.getNormal()), rowNum, true, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
  }
}
