package com.agilex.healthcare.mbb.pdf.pages;

import java.util.Date;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mbb.pdf.PageEvent;
import com.agilex.healthcare.mbb.pdf.Stylesheet;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;

public class MicrobiologyLabPage extends AbstractPage {

  public MicrobiologyLabPage(Document document, PageEvent event, PdfWriter writer, PdfGenerationContext context) {
    super(document, event, writer, context);
  }

  public void create() throws DocumentException {
    String domain = Domain.microLabResult;
    addHeading(context.getMessageSource().getMessage("mbb.report.microbiology.title", null, context.getLocale()), domain);
    addTextDateRange(context.getDateFilter());

    LabResults microbiologyResults = (LabResults)context.getInformation(domain);

    if (NullChecker.isNotNullish(microbiologyResults)) {
      for (LabResult result : microbiologyResults) {
        addResult(document, result);
      }
    } else {
      addNoDataFound();
    }
  }

  private void addResult(Document document, LabResult result) throws DocumentException {
    final Date DATE = result.getResultedDate();
    final String TEST = result.getTestname();
    final String FACILITY = "data not found";
    final String REPORT = result.getValue();

    PdfPTable resultInformationTable = createInformationTable();
    addInformationRow(resultInformationTable, false, context.getMessageSource().getMessage("mbb.report.microbiology.date", null, context.getLocale()), DateHelper.formatDate(DATE));
    addInformationRow(resultInformationTable, false, context.getMessageSource().getMessage("mbb.report.microbiology.test", null, context.getLocale()), TEST);
    addInformationRow(resultInformationTable, false, context.getMessageSource().getMessage("mbb.report.microbiology.facility", null, context.getLocale()), FACILITY);
    document.add(resultInformationTable);

    PdfPTable table = createTable();
    document.add(table);

    Paragraph report = new Paragraph(REPORT, Stylesheet.getNormal());
    report.setIndentationLeft(5);
    report.setIndentationRight(5);
    report.setLeading(0f, 1.0f);
    document.add(report);
  }

  private PdfPTable createTable() throws DocumentException {
    PdfPTable table = new PdfPTable(1);
    table.setWidthPercentage(100);
    table.setSpacingBefore(0);
    table.setSpacingAfter(10);
    table.setKeepTogether(false);
    table.setSplitRows(false);
    table.setHeaderRows(1);

    PdfPCell cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.microbiology.microbiologyReport", null, context.getLocale()), true, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);

    return table;
  }
}
