package com.agilex.healthcare.mbb.pdf.pages;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mbb.pdf.PageEvent;
import com.agilex.healthcare.mbb.pdf.Stylesheet;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.utility.NullChecker;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;

public class MedicationPage extends AbstractPage {

  public MedicationPage(Document document, PageEvent event, PdfWriter writer, PdfGenerationContext context) {
    super(document, event, writer, context);
  }

  public void create() throws DocumentException {
    String domain = Domain.medication;
    addHeading(context.getMessageSource().getMessage("mbb.report.medications.title", null, context.getLocale()), domain);
    addUpdate(context.getMessageSource().getMessage("mbb.report.medications.updateFrequency", null, context.getLocale()), domain);

    PdfPTable table = createTable();

    Medications medications = (Medications)context.getInformation(domain);

    if (NullChecker.isNotNullish(medications)) {
      int i = 0;
      for (Medication medication : medications) {
        boolean lastRow = (i == (medications.size() - 1));
        addMedication(table, medication, i++, lastRow);
      }

      document.add(table);
    } else {
      addNoDataFound();
    }
  }

  private PdfPTable createTable() throws DocumentException {
    PdfPTable table = new PdfPTable(3);
    table.setWidthPercentage(100);
    table.setWidths(new int[] { 70, 15, 15 });
    table.setSpacingBefore(10);
    table.setSpacingAfter(10);
    table.setHeaderRows(1);

    PdfPCell cell;
    cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.medications.activeAndRecentlyExpired", null, context.getLocale()), false, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);

    cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.medications.status", null, context.getLocale()), false, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);

    cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.medications.source", null, context.getLocale()), true, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);

    return table;
  }

  private void addMedication(PdfPTable table, Medication medication, int rowNum, boolean lastRow) {
    final String NAME = medication.getDrugName();
    final String DESCRIPTION = medication.getMedicationDetail();
    final String STATUS = medication.getStatus();
    final String SOURCE = medication.getSourceSystem();

    Phrase phrase = new Phrase();
    phrase.add(new Chunk(NAME, Stylesheet.getNormal()));
    if (NullChecker.isNotNullish(DESCRIPTION)) {
      phrase.add(new Chunk(Chunk.NEWLINE));
      phrase.add(new Chunk(DESCRIPTION, Stylesheet.getNormal()));
    }
    PdfPCell cell = createCell(phrase, rowNum, false, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createCell(new Phrase(STATUS, Stylesheet.getNormal()), rowNum, false, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createCell(new Phrase(SOURCE, Stylesheet.getNormal()), rowNum, true, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
  }
}
