package com.agilex.healthcare.mbb.pdf.pages;

import java.lang.String;
import java.util.Date;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mbb.pdf.PageEvent;
import com.agilex.healthcare.mbb.pdf.Stylesheet;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointment;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;

public class AppointmentPage extends AbstractPage {

  public AppointmentPage(Document document, PageEvent event, PdfWriter writer, PdfGenerationContext context) {
    super(document, event, writer, context);
  }

  public void create() throws DocumentException {
    String domain = Domain.appointment;
    addHeading(getMessage("mbb.report.appointments.title", null), domain);
    addUpdate(getMessage("mbb.report.appointments.updateFrequency", null), domain);
    addTextDateRange(context.getDateFilter());

    Appointments appointments = (Appointments)context.getInformation(domain);

    if (NullChecker.isNotNullish(appointments)) {
      for (Appointment appointment :  appointments) {
        addAppointment(document, appointment);
      }
    } else {
      addNoDataFound();
    }
  }

  private void addAppointment(Document document, Appointment appointment) throws DocumentException {
    final Date DATE = appointment.getDate();
    final String CLINIC = appointment.getClinicName();
    final String FACILITY = appointment.getFacilityName();
    final String NOTE = NullChecker.isNullish(appointment.getClinicalNotes()) ? getMessage("mbb.report.noNoteFound", null) : appointment.getClinicalNotes();

    PdfPTable table = createTable();
    document.add(table);

    PdfPTable noteInformationTable = createInformationTable();
    addInformationRow(noteInformationTable, false, getMessage("mbb.report.appointments.date", null), DateHelper.formatDateTimeNoSeconds(DATE));
    addInformationRow(noteInformationTable, false, getMessage("mbb.report.appointments.clinic", null), CLINIC);
    addInformationRow(noteInformationTable, false, getMessage("mbb.report.appointments.facility", null), FACILITY);
    document.add(noteInformationTable);

    Paragraph note = new Paragraph(NOTE, Stylesheet.getNormal());
    setupParagraph(note);
    document.add(note);
    addSolidLine();
    addBlankLines(1);
  }

  private PdfPTable createTable() throws DocumentException {
    PdfPTable table = new PdfPTable(1);
    table.setWidthPercentage(100);
    table.setSpacingBefore(0);
    table.setSpacingAfter(10);
    table.setKeepTogether(false);
    table.setSplitRows(false);
    table.setHeaderRows(1);

    PdfPCell cell = createTableHeader(getMessage("mbb.report.appointments.notes", null), true, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);

    return table;
  }
}
