package com.agilex.healthcare.mbb.pdf.pages;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mbb.pdf.PageEvent;
import com.agilex.healthcare.mbb.pdf.Stylesheet;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.utility.NullChecker;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;

public class AllergyPage extends AbstractPage {

  public AllergyPage(Document document, PageEvent event, PdfWriter writer, PdfGenerationContext context) {
    super(document, event, writer, context);
  }

  public void create() throws DocumentException {
    String domain = Domain.allergy;
    addHeading(context.getMessageSource().getMessage("mbb.report.allergies.title", null, context.getLocale()), domain);
    addUpdate(context.getMessageSource().getMessage("mbb.report.allergies.updateFrequency", null, context.getLocale()), domain);

    PdfPTable table = createTable();

    Allergies allergies = (Allergies)context.getInformation(domain);

    if (NullChecker.isNotNullish(allergies)) {
      int i = 0;
      for (Allergy allergy : allergies) {
        boolean lastRow = (i == (allergies.size() - 1));
        addAllergy(table, allergy, i++, lastRow);
      }

      document.add(table);
    } else {
      addNoDataFound();
    }

  }

  private PdfPTable createTable() throws DocumentException {
    PdfPTable table = new PdfPTable(3);
    table.setWidthPercentage(100);
    table.setWidths(new int[] { 50, 35, 15 });
    table.setSpacingBefore(10);
    table.setSpacingAfter(10);
    table.setHeaderRows(1);

    PdfPCell cell;
    cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.allergies.allergen", null, context.getLocale()), false, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.allergies.reaction", null, context.getLocale()), false, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createTableHeader(context.getMessageSource().getMessage("mbb.report.allergies.source", null, context.getLocale()), true, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);

    return table;
  }

  private void addAllergy(PdfPTable table, Allergy allergy, int rowNum, boolean lastRow) {
    final String NAME = allergy.getSubstance();
    final String REACTION = allergy.getReaction();
    final String SOURCE = allergy.getSourceSystem();

    PdfPCell cell = createCell(new Phrase(NAME, Stylesheet.getNormal()), rowNum, false, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createCell(new Phrase(REACTION, Stylesheet.getNormal()), rowNum, false, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
    cell = createCell(new Phrase(SOURCE, Stylesheet.getNormal()), rowNum, true, lastRow, PdfPCell.ALIGN_LEFT);
    table.addCell(cell);
  }
}
