package com.agilex.healthcare.mbb.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;

public class Stylesheet {
  private static Font normal = FontFactory.getFont(FontFactory.HELVETICA, 10, Font.NORMAL, BaseColor.BLACK);
  private static Font bold = FontFactory.getFont(FontFactory.HELVETICA_BOLD, 10, Font.NORMAL, BaseColor.BLACK);
  private static Font boldLarge = FontFactory.getFont(FontFactory.HELVETICA_BOLD, 12, Font.NORMAL, BaseColor.BLACK);
  private static Font italic = FontFactory.getFont(FontFactory.TIMES_ITALIC, 10, Font.NORMAL, BaseColor.BLACK);
  private static Font italicLarge = FontFactory.getFont(FontFactory.TIMES_ITALIC, 12, Font.NORMAL, BaseColor.BLACK);
  private static Font italicUnderline = FontFactory.getFont(FontFactory.TIMES_ITALIC, 10, Font.UNDERLINE, BaseColor.BLACK);
  private static Font blue = FontFactory.getFont(FontFactory.HELVETICA, 15, Font.NORMAL, BaseColor.BLUE);
  private static Font blueItalic = FontFactory.getFont(FontFactory.TIMES_ITALIC, 15, Font.NORMAL, BaseColor.BLUE);
  private static Font blueBoldItalic = FontFactory.getFont(FontFactory.HELVETICA, 15, Font.BOLDITALIC, BaseColor.BLUE);
  private static Font h1 = FontFactory.getFont(FontFactory.HELVETICA, 15, Font.NORMAL, BaseColor.WHITE);
  private static Font h2 = FontFactory.getFont(FontFactory.HELVETICA_BOLD, 15, Font.NORMAL, BaseColor.BLACK);
  private static Font h3 = FontFactory.getFont(FontFactory.HELVETICA, 12, Font.NORMAL, BaseColor.BLACK);

  private static BaseColor tableHeader = new BaseColor(0xff, 0xff, 0xff);
  private static BaseColor tableRow1 = BaseColor.WHITE;
  private static BaseColor tableRow2 = new BaseColor(0xff, 0xff, 0xcc);
  private static BaseColor infoTableKey = BaseColor.LIGHT_GRAY;
  private static BaseColor infoTableValue = BaseColor.WHITE;
  
  public static Font getNormal() {
    return normal;
  }

  public static Font getBold() {
    return bold;
  }

  public static Font getBoldLarge() {
    return boldLarge;
  }

  public static Font getBlue() {
    return blue;
  }

  public static Font getBlueItalic() {
    return blueItalic;
  }

  public static Font getBlueBoldItalic() {
    return blueBoldItalic;
  }

  public static Font getH1() {
    return h1;
  }

  public static Font getH2() {
    return h2;
  }
  
  public static Font getH3() {
    return h3;
  }

  public static Font getItalic() {
    return italic;
  }

  public static Font getItalicLarge() {
    return italicLarge;
  }
  
  public static Font getItalicUnderline() {
    return italicUnderline;
  }

  public static BaseColor getTableHeader() {
    return tableHeader;
  }

  public static BaseColor getTableRow1() {
    return tableRow1;
  }

  public static BaseColor getTableRow2() {
    return tableRow2;
  }

  public static BaseColor getInfoTableKey() {
    return infoTableKey;
  }

  public static BaseColor getInfoTableValue() {
    return infoTableValue;
  }
}
