package com.agilex.healthcare.mbb.pdf;

import java.io.OutputStream;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mbb.pdf.pages.AbstractPage;
import com.agilex.healthcare.mbb.pdf.pages.AdmissionPage;
import com.agilex.healthcare.mbb.pdf.pages.AllergyPage;
import com.agilex.healthcare.mbb.pdf.pages.AppointmentPage;
import com.agilex.healthcare.mbb.pdf.pages.CoverPage;
import com.agilex.healthcare.mbb.pdf.pages.DemographicPage;
import com.agilex.healthcare.mbb.pdf.pages.HealthAdvocateRequestPage;
import com.agilex.healthcare.mbb.pdf.pages.LabPage;
import com.agilex.healthcare.mbb.pdf.pages.MedicationHistoryPage;
import com.agilex.healthcare.mbb.pdf.pages.MedicationPage;
import com.agilex.healthcare.mbb.pdf.pages.ProblemPage;
import com.agilex.healthcare.mbb.pdf.pages.RadiologyPage;
import com.agilex.healthcare.mbb.pdf.pages.SurgeryPage;
import com.agilex.healthcare.mbb.pdf.pages.VitalPage;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfWriter;

public class PdfPageFactory {
  private Document document;
  private PageEvent event;
  private PdfWriter writer;
  private PdfGenerationContext context;
  private OutputStream outputStream;

  AbstractPage admissionPage;
  AbstractPage allergyPage;
  AbstractPage appointmentPage;
  AbstractPage coverPage;
  AbstractPage demographicPage;
  AbstractPage labPage;
  AbstractPage medicationPage;
  AbstractPage medicationHistoryPage;
  AbstractPage problemPage;
  AbstractPage radiologyPage;
  AbstractPage surgeryPage;
  AbstractPage vitalPage;
  AbstractPage healthAdvocateRequestPage;

  public PdfPageFactory(Document document, PageEvent event, PdfWriter writer, PdfGenerationContext context) {
    this.document = document;
    this.event = event;
    this.writer = writer;
    this.context = context;
  }
  public PdfPageFactory(Document document, PageEvent event, PdfWriter writer, PdfGenerationContext context, OutputStream outputStream){
    this(document, event, writer, context);
    this.outputStream = outputStream;
  }

  public void createCoverPage() throws DocumentException {
    if (coverPage == null) {
      coverPage = new CoverPage(document, event, writer, context);
    }

    coverPage.create();
  }

  public void createDemographicPage() throws DocumentException {
    if (context.isVisible(Domain.demographic)) {
      if (demographicPage == null) {
        demographicPage = new DemographicPage(document, event, writer, context);
      }

      demographicPage.create();
    }
  }

  public void createAdmissionPage() throws DocumentException {
    if (context.isVisible(Domain.admission)) {
      if (admissionPage == null) {
        admissionPage = new AdmissionPage(document, event, writer, context);
      }

      admissionPage.create();
    }
  }

  public void createAllergyPage() throws DocumentException {
    if (context.isVisible(Domain.allergy)) {
      if (allergyPage == null) {
        allergyPage = new AllergyPage(document, event, writer, context);
      }

      allergyPage.create();
    }
  }

  public void createAppointmentPage() throws DocumentException {
    if (context.isVisible(Domain.appointment)) {
      if (appointmentPage == null) {
        appointmentPage = new AppointmentPage(document, event, writer, context);
      }

      appointmentPage.create();
    }
  }

  public void createLabPage() throws DocumentException {
    if (context.isVisible(Domain.labResult)) {
      if (labPage == null) {
        labPage = new LabPage(document, event, writer, context);
      }

      labPage.create();
    }
  }

  public void createMedicationPage() throws DocumentException {
    if (context.isVisible(Domain.medication)) {
      if (medicationPage == null) {
        medicationPage = new MedicationPage(document, event, writer, context);
      }

      medicationPage.create();
    }
  }

  public void createMedicationHistoryPage() throws DocumentException {
    if (context.isVisible(Domain.medicationHistory)) {
      if (medicationHistoryPage == null) {
        medicationHistoryPage = new MedicationHistoryPage(document, event, writer, context);
      }

      medicationHistoryPage.create();
    }
  }

  public void createProblemPage() throws DocumentException {
    if (context.isVisible(Domain.problem)) {
      if (problemPage == null) {
        problemPage = new ProblemPage(document, event, writer, context);
      }

      problemPage.create();
    }
  }

  public void createRadiologyPage() throws DocumentException {
    if (context.isVisible(Domain.radiologyResult)) {
      if (radiologyPage == null) {
        radiologyPage = new RadiologyPage(document, event, writer, context);
      }

      radiologyPage.create();
    }
  }

  public void createSurgeryPage() throws DocumentException {
    if (context.isVisible(Domain.surgery)) {
      if (surgeryPage == null) {
        surgeryPage = new SurgeryPage(document, event, writer, context);
      }

      surgeryPage.create();
    }
  }

  public void createVitalPage() throws DocumentException {
    if (context.isVisible(Domain.vital)) {
      if (vitalPage == null) {
        vitalPage = new VitalPage(document, event, writer, context);
      }

      vitalPage.create();
    }
  }

  public void createHealthAdvocateRequestPage() throws DocumentException {
    if (context.isVisible(Domain.healthAdvocateRequest)) {

      healthAdvocateRequestPage = new HealthAdvocateRequestPage(document, event, writer, context, outputStream);
      healthAdvocateRequestPage.create();
    }
  }
}
