package com.agilex.healthcare.mbb.pdf;

import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.io.IOUtils;

import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;


public class PageEvent extends PdfPageEventHelper {
	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(PageEvent.class);
    private String[] header = new String[2];
    private PdfTemplate totalNumberOfPages;
    private PdfTemplate confidentialWatermark;
    Image total;

    public PageEvent() {
    	header[0] = "";
    	header[1] = "CONFIDENTIAL";
    }

    public PageEvent(PdfGenerationContext context) {
    	init(context);
    }

    private void init(PdfGenerationContext context) {
    	String firstName = context.getPatient().getFirstName();
    	String lastName = context.getPatient().getLastName();
    	header[0] = String.format("%s, %s", convertToUppercase(lastName), convertToUppercase(firstName));
    	header[1] = "CONFIDENTIAL";
    }

    private String convertToUppercase(String value) {
    	return value != null ? value.toUpperCase() : null;
    }

    @Override
    public void onOpenDocument(PdfWriter writer, Document document) {
    	PdfContentByte canvas = writer.getDirectContent();

    	totalNumberOfPages = canvas.createTemplate(30, 16);
    	
		confidentialWatermark = canvas.createTemplate(136, 400);

		InputStream inputStream = null;
    	try {
			inputStream = PageEvent.class.getClassLoader().getResourceAsStream("com/agilex/healthcare/mobilehealthplatform/pdf/confidential.png");

			byte[] byteArray = IOUtils.toByteArray(inputStream);
    		inputStream.close();
    		inputStream = null;

			Image image = Image.getInstance(byteArray);

    		image.setCompressionLevel(0);
    		image.setAbsolutePosition(0, 0);

    		confidentialWatermark.addImage(image);
    		confidentialWatermark.setAccessibleAttribute(PdfName.ALT, new PdfString("CONFIDENTIAL"));
    		
    		total = Image.getInstance(totalNumberOfPages);
    		totalNumberOfPages.setRole(PdfName.SPAN);

    	} catch(IOException e) {
    		if (inputStream != null) {
    			try {
    				inputStream.close();
    			} catch (IOException ioException) {
                    LOGGER.error("Exception occurred adding confidential image to a page", ioException);
    			}
    		}
            throw new ExceptionConverter(e);
        } catch(BadElementException e) {
            throw new ExceptionConverter(e);
        } catch(DocumentException e) {
            throw new ExceptionConverter(e);
        }
    }

    @Override
    public void onEndPage(PdfWriter writer, Document document) {
    	
		PdfContentByte canvas = writer.getDirectContent();
		canvas.beginMarkedContentSequence(PdfName.ARTIFACT);
		canvas.addTemplate(confidentialWatermark, 440, 110);
		canvas.endMarkedContentSequence();
		Font helvetica = FontFactory.getFont(FontFactory.HELVETICA, 10, Font.NORMAL, BaseColor.BLACK);
		ColumnText.showTextAligned(writer.getDirectContent(), Element.ALIGN_LEFT,
		new Phrase(header[0], helvetica), 34, 815, 0);
		ColumnText.showTextAligned(writer.getDirectContent(), Element.ALIGN_CENTER,
				new Phrase(header[1], Stylesheet.getBoldLarge()), 300, 815, 0);
		ColumnText.showTextAligned(writer.getDirectContent(), Element.ALIGN_RIGHT,
				new Phrase(String.format("Page %d of", writer.getPageNumber()), Stylesheet.getNormal()), 550, 815, 0);
		
		
		canvas.addTemplate(totalNumberOfPages, 553, 815);
    }


    public void onCloseDocument(PdfWriter writer, Document document) {
		Font helvetica = FontFactory.getFont(FontFactory.HELVETICA, 10, Font.NORMAL, BaseColor.BLACK);
		ColumnText.showTextAligned(totalNumberOfPages, Element.ALIGN_LEFT,
						new Phrase(String.valueOf(writer.getPageNumber() - 1), helvetica), 0, 0, 0);
    }
}
