package com.agilex.healthcare.mbb.dataservice;

import java.io.OutputStream;

import org.springframework.context.MessageSource;

import com.agilex.healthcare.mbb.datalayer.PdfDataLayer;
import com.agilex.healthcare.mbb.datalayer.PdfDataLayerItext;
import com.agilex.healthcare.mbb.datalayer.PdfGenerationContext;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessage;
import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

public class PdfDataService {
	private PdfDataLayer pdfDataLayer;
	private PatientDataService patientDataService;

	public PdfDataService() {
		pdfDataLayer = new PdfDataLayerItext();
		patientDataService = new PatientDataService();
	}

	public PdfDataService(PdfDataLayer pdfDataLayer) {
		this.pdfDataLayer = pdfDataLayer;
	}

	public void generateReport(OutputStream outputStream, PdfGenerationContext context) {
		populateContext(context);
		this.pdfDataLayer.generateReport(outputStream, context);
	}

	public void generateHealthAdvocateRequestForm (OutputStream outputStream, PdfGenerationContext context) {
		populateContext(context);
		this.pdfDataLayer.generateHealthAdvocateRequestForm(outputStream, context);	
	}
	
	public void generateSecureMessagePdf (OutputStream outputStream, MessageSource messageSource, SecureMessage secureMessage) {
		this.pdfDataLayer.generateSecureMessagePdf(outputStream, messageSource, secureMessage);	
	}
	
	private void populateContext(PdfGenerationContext context) {
		if (context.getPatient() == null) {
			Patient patient = MhpUserFactory.createFromSecurityContext().getPatient();
			context.setPatient(patient);
		}

		if (context.getInformation(Domain.demographic) == null) {
			context.setInformation(Domain.demographic, patientDataService.getPatientDemographics(context.getPatientIdentifier(), ScopeFilter.getInstanceForLongitudinalScope()));
		}
	}
}
