package com.agilex.healthcare.mbb.datalayer;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

import org.springframework.context.MessageSource;

import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterImpl;

public class PdfGenerationContext {
	private PatientIdentifier patientIdentifier;
	
	private HashMap<String, Boolean> displayMap = new HashMap<String, Boolean>();
	private HashMap<String, Object> informationMap = new HashMap<String, Object>();
	
	private MessageSource messageSource;
	private Locale locale;
	
	private DateFilter dateFilter = new DateFilterImpl();
	private Date reportDate = new Date();
	private Patient patient;
	
	public PdfGenerationContext() {
	}
	
	public PatientIdentifier getPatientIdentifier() {
		return patientIdentifier;
	}

	public void setPatientIdentifier(PatientIdentifier patientIdentifier) {
		this.patientIdentifier = patientIdentifier;
	}
	
	public DateFilter getDateFilter() {
		return dateFilter;
	}

	public void setDateFilter(DateFilter dateFilter) {
		this.dateFilter = dateFilter;
	}

	public Patient getPatient() {
		return patient;
	}

	public void setPatient(Patient patient) {
		this.patient = patient;
	}

	public Date getReportDate() {
		return reportDate;
	}

	public void setReportDate(Date reportDate) {
		this.reportDate = reportDate;
	}

	public Boolean isVisible(String domain) {
		Boolean visible = displayMap.get(domain);
		return visible == null ? false : visible;
	}
	
	public Object getInformation(String domain) {
		return informationMap.get(domain);
	}
	
	public void setVisible(String domain, Boolean visible) {
		displayMap.put(domain, visible);
	}
	
	public void setInformation(String domain, Object object) {
		informationMap.put(domain, object);
	}

	public MessageSource getMessageSource() {
		return messageSource;
	}

	public void setMessageSource(MessageSource messageSource) {
		this.messageSource = messageSource;
	}

	public Locale getLocale() {
		return locale;
	}

	public void setLocale(Locale locale) {
		this.locale = locale;
	}
}
