package com.agilex.healthcare.mbb.datalayer;

import java.io.OutputStream;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;

import org.apache.log4j.Logger;
import org.springframework.context.MessageSource;

import com.agilex.healthcare.mbb.pdf.PageEvent;
import com.agilex.healthcare.mbb.pdf.PdfPageFactory;
import com.agilex.healthcare.mbb.pdf.securemessage.SecureMessagePDF;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessage;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;

public class PdfDataLayerItext implements PdfDataLayer {
  private static final Logger LOGGER = Logger.getLogger(PdfDataLayerItext.class);
  Document document;

  public PdfDataLayerItext() {
    initializeDocument();
  }

  private void initializeDocument() {
    Rectangle pageSize = new Rectangle(PageSize.A4);
    pageSize.setBackgroundColor(new BaseColor(0xFF, 0xFF, 0xFF));
    document = new Document(pageSize);
    document.setMargins(45, 45, 60, 45);
  }

  public void generateReport(OutputStream outputStream, PdfGenerationContext context) {
    try {
      PageEvent event = new PageEvent(context);
      PdfWriter writer = PdfWriter.getInstance(document, outputStream);
      writer.setPdfVersion(PdfWriter.VERSION_1_7);
      
      String title = "My Mobile Blue Button Report";
      document.addTitle(title);

      writer.createXmpMetadata();
      writer.addViewerPreference(PdfName.DISPLAYDOCTITLE, new PdfBoolean(true));
      writer.setLinearPageMode();
      writer.setPageEvent(event);
      writer.setTagged();

      document.open();
      document.addLanguage("en-us");
      createPages(event, writer, context);
      document.close();
    } catch (DocumentException e) {
      LOGGER.error("Failed to generate MBB Report", e);
      throw new WebApplicationException(Status.INTERNAL_SERVER_ERROR);
    }
  }

  public void generateHealthAdvocateRequestForm(OutputStream outputStream, PdfGenerationContext context) {
    try {
      //event and writer are not needed.  Also, the event mechanism seems to prevent correct operation of the form filling
      document.open();
      createHealthAdvocateRequestFormPage(context, outputStream);
      document.close();
    } catch (DocumentException e) {
      LOGGER.error("Failed to generate HealthAdvocate Request Form", e);
      throw new WebApplicationException(Status.INTERNAL_SERVER_ERROR);
    }
  }

  public void generateSecureMessagePdf(OutputStream outputStream, MessageSource messageSource, SecureMessage secureMessage) {
    try {
      PageEvent event = new PageEvent();
      PdfWriter writer = PdfWriter.getInstance(document, outputStream);
      writer.setLinearPageMode();
      writer.setPageEvent(event);

      document.open();
      createSecureMessagePdf(event, writer, messageSource, secureMessage, outputStream);
      document.close();
    } catch (DocumentException e) {
      LOGGER.error("Failed to generate Secure Message PDF", e);
      throw new WebApplicationException(Status.INTERNAL_SERVER_ERROR);
    }
  }

  private void createSecureMessagePdf(PageEvent event, PdfWriter writer, MessageSource messageSource, SecureMessage secureMessage, OutputStream outputStream)  throws DocumentException {
    SecureMessagePDF secureMessagePDF = new SecureMessagePDF(document, event, writer, messageSource, secureMessage);
    secureMessagePDF.create();
  }

  private void createHealthAdvocateRequestFormPage(PdfGenerationContext context, OutputStream outputStream)  throws DocumentException {
    PdfPageFactory pdfPageFactory = new PdfPageFactory(document, null, null, context, outputStream);
    pdfPageFactory.createHealthAdvocateRequestPage();
  }

  private void createPages(PageEvent event, PdfWriter writer, PdfGenerationContext context) throws DocumentException {
    PdfPageFactory pdfPageFactory = new PdfPageFactory(document, event, writer, context);
    pdfPageFactory.createCoverPage();
    pdfPageFactory.createDemographicPage();
    pdfPageFactory.createProblemPage();
    pdfPageFactory.createAllergyPage();
    pdfPageFactory.createMedicationPage();
    pdfPageFactory.createSurgeryPage();
    pdfPageFactory.createVitalPage();
    pdfPageFactory.createMedicationHistoryPage();
    pdfPageFactory.createLabPage();
    pdfPageFactory.createRadiologyPage();
    pdfPageFactory.createAppointmentPage();
    pdfPageFactory.createAdmissionPage();
  }
}
