package com.agilex.healthcare.mbb.datalayer;

import com.agilex.healthcare.mobilehealthplatform.domain.ClinicalDomain;
import com.agilex.healthcare.mobilehealthplatform.domain.ClinicalDomains;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;

import javax.ws.rs.core.UriBuilder;

public class ClinicalDomainsDataLayerMock implements ClinicalDomainsDataLayer {
	private static final String BASE_PATH="content/";
	private ClinicalDomains shareDomainsStore;
	
	
	private ClinicalDomains createMockShareDomains(String baseUrl) {
		ClinicalDomains shareDomains = new ClinicalDomains();
		
		ClinicalDomain shareDomainDemographics = new ClinicalDomain();
		ClinicalDomain shareDomainAllergy = new ClinicalDomain();
		ClinicalDomain shareDomainProblem = new ClinicalDomain();		
		ClinicalDomain shareDomainMedication = new ClinicalDomain();
		ClinicalDomain shareDomainSurgery = new ClinicalDomain();
		ClinicalDomain shareDomainRadiology = new ClinicalDomain();
		ClinicalDomain shareDomainClinicalAppointments = new ClinicalDomain();
		ClinicalDomain shareDomainHospitalizations = new ClinicalDomain();
		ClinicalDomain shareDomainVitals = new ClinicalDomain();
		ClinicalDomain shareDomainMedicationHistory = new ClinicalDomain();
		ClinicalDomain shareDomainLabs = new ClinicalDomain();
		ClinicalDomain shareDomainMicro = new ClinicalDomain();

		shareDomainDemographics.setTitle("Contact Information");
		shareDomainDemographics.setUrl(UriBuilder.fromPath(BASE_PATH + Domain.demographic).build());
		shareDomains.add(shareDomainDemographics);
		
		shareDomainProblem.setTitle("Medical Diagnoses");
		shareDomainProblem.setUrl(UriBuilder.fromPath(BASE_PATH + Domain.problem).build());
		shareDomains.add(shareDomainProblem);
		
		shareDomainAllergy.setTitle("Allergies");
		shareDomainAllergy.setUrl(UriBuilder.fromPath(BASE_PATH + Domain.allergy).build());
		shareDomains.add(shareDomainAllergy);
		
		shareDomainMedication.setTitle("Medication List");
		shareDomainMedication.setUrl(UriBuilder.fromPath(BASE_PATH + Domain.medication).build());
		shareDomains.add(shareDomainMedication);
		
		shareDomainSurgery.setTitle("Surgeries");
		shareDomainSurgery.setUrl(UriBuilder.fromPath(BASE_PATH + Domain.surgery).build());
		shareDomains.add(shareDomainSurgery);
		
		shareDomainVitals.setTitle("Vitals");
		shareDomainVitals.setUrl(UriBuilder.fromPath(BASE_PATH + Domain.vital).build());
		shareDomains.add(shareDomainVitals);

		shareDomainMedicationHistory.setTitle("Medication History");
		shareDomainMedicationHistory.setUrl(UriBuilder.fromPath(BASE_PATH + Domain.medicationHistory).build());
		shareDomains.add(shareDomainMedicationHistory);

		shareDomainLabs.setTitle("Lab Results");
		shareDomainLabs.setUrl(UriBuilder.fromPath(BASE_PATH + Domain.labResult).build());
		shareDomains.add(shareDomainLabs);

		shareDomainRadiology.setTitle("Radiology Exams");
		shareDomainRadiology.setUrl(UriBuilder.fromPath(BASE_PATH + Domain.radiologyResult).build());
		shareDomains.add(shareDomainRadiology);
		
//		shareDomainClinicalAppointments.setTitle("Clinical Notes");
//		shareDomainClinicalAppointments.setUrl(BASE_PATH + Domain.appointment);
//		shareDomains.add(shareDomainClinicalAppointments);
//
//		shareDomainHospitalizations.setTitle("Discharge Summaries");
//		shareDomainHospitalizations.setUrl(BASE_PATH + Domain.admission);
//		shareDomains.add(shareDomainHospitalizations);
		
		return shareDomains;
	}

	public ClinicalDomains getShareDomains(String baseUrl) {
		shareDomainsStore = createMockShareDomains(baseUrl);

		return shareDomainsStore;
	}

}
